# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

def prefdlReader():
   # No prefdl for vEOS-lab systems, return a quasi-valid looking one (it
   # won't be used, but genprefdl would at least not assert).
   return b"""Sku: vEOS-lab
SerialNumber:
SID: vEOS-lab
PCA: PCA000000000
HwRev: 01.00
HwApi: 01.00
MacAddrBase:
"""

def Plugin( context ):
   # Guard - Only run on supported platforms
   supportedPlatforms = [ 'veos' ]
   if context.platform() not in supportedPlatforms:
      return

   # Register reader function with high priority
   context.prefdlReaderIs( prefdlReader, priority=10 )
