# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import annotations

import json
import os
import Tac
from typing import TYPE_CHECKING
if TYPE_CHECKING:
   CmvState = Tac.Type( "AirStream::CmvState" )

def loadCmvProfiles( cmvState: CmvState ):
   # Parse all typeinfo files. We need to iterate through every PathAndTypes'
   # "Instances", if they contain "@cmvEosPath" we create a CmvPath for the
   # PathAndTypes' type, including each of the @cmvEosPath in the eosAttr collection.
   # We then add that CmvPath to the CmvProfile and move on to the next typeinfo
   # file.
   typeInfoPath = '/usr/share/typeinfo'
   jsonFiles = [
      os.path.join( typeInfoPath, jsonF ) for jsonF in os.listdir( typeInfoPath )
      if jsonF.endswith( '.json' ) ]
   for jsonFile in jsonFiles:
      with open( jsonFile ) as f:
         data = json.load( f )
      cmvPaths = []
      for tacType in data[ 'PathsAndTypes' ]:
         typeName = tacType[ 'EosTypeName' ]
         cmvTypePath = tacType[ 'EosPath' ]
         instances = tacType[ 'Instances' ]
         cmvPath = Tac.Value( 'AirStream::CmvPath', cmvTypePath )
         # Currently there is no efficient way to tell if the current tacType in
         # PathsAndTypes is a CMV type or not. So for now we loop through its
         # "Instances" and check if we find a @cmvEosPath property. If so, add it to
         # CmvPath
         for attrName, attrProperties in instances.items():
            if '@cmvEosPath' not in attrProperties:
               continue
            attrEosPath = attrProperties[ '@cmvEosPath' ]
            cmvPath.cmvType = typeName
            cmvPath.eosAttr[ attrName ] = attrEosPath
         if cmvPath.eosAttr:
            cmvPaths.append( cmvPath )
      for cmvPath in cmvPaths:
         cmvState.cmvProfile.cmvPath.addMember( cmvPath )
