#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.
import sys
import syslog
import weakref
import Tac

def log( msg ):
   syslog.syslog( syslog.LOG_NOTICE, msg )
   print( msg, file=sys.stderr )

class DataProvider:

   # subclass needs to provide the following
   COUNTER_TYPE = None
   COMMAND_OPT = None
   HIDDEN_COMMAND_OPT = False

   # base class for a particular counter type
   def __init__( self, collector ):
      self.collector = weakref.proxy( collector )

   def doInit( self, mg, shmemEm ):
      # initialize, typically mounting from Sysdb/Smash
      pass

   def initDone( self ):
      # After mounting is completed
      pass

   def requestUpdate( self ):
      # if we need to request polling for the counter
      pass

   def getCounters( self ):
      raise NotImplementedError
