# Copyright (c) 2013 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.
import Logging

# Arista Logging messages emitted by the HadoopTracer agent
MAPREDUCEMONITOR_TASKTRACKER_ACTIVE = Logging.LogHandle(
      "MAPREDUCEMONITOR_TASKTRACKER_ACTIVE",
      severity=Logging.logInfo,
      fmt="TaskTracker %s changed state to active",
      explanation="TaskTracker resolved as locally attached by the switch",
      recommendedAction=Logging.NO_ACTION_REQUIRED )

MAPREDUCEMONITOR_TASKTRACKER_INACTIVE = Logging.LogHandle(
      "MAPREDUCEMONITOR_TASKTRACKER_INACTIVE",
      severity=Logging.logInfo,
      fmt="TaskTracker %s changed state to inactive due to: %s",
      explanation="TaskTracker cannot be determined to be locally attached "
         "either due to unresolved ARP entry from TaskTracker IP address"
         " or failure to resolve the TaskTracker name to an IP address."
         "The log message provides the cause.",
      recommendedAction=
         "Check the connectivity from the switch to the TaskTracker and "
         "if TaskTracker name to IP address resolution can be performed from the "
         "switch." )

MAPREDUCEMONITOR_TASKTRACKER_REMOVED = Logging.LogHandle(
      "MAPREDUCEMONITOR_TASKTRACKER_REMOVED",
      severity=Logging.logInfo,
      fmt="TaskTracker %s is not longer part of the Hadoop cluster %s",
      explanation=
        "The TaskTracker is no longer part of the cluster as announced by the "
        "JobTracker.",
      recommendedAction=Logging.NO_ACTION_REQUIRED )
