# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from IpLibConsts import DEFAULT_VRF

def checkServiceEnabled( serverConfig, service, vrf ):
   serviceEnabled = ( service in serverConfig.service and
                      serverConfig.service[ service ].enabled )

   # check if service enabled in VRF
   if vrf in serverConfig.vrfConfig:
      vrfConfig = serverConfig.vrfConfig[ vrf ]
      if service in vrfConfig.vrfService:
         return serviceEnabled and vrfConfig.vrfService[ service ]

   # for default VRF, also check if service enabled with no VRF configuration
   if vrf == DEFAULT_VRF:
      for vrfConfig in serverConfig.vrfConfig.values():
         # if service is configured in any VRF, return False
         if service in vrfConfig.vrfService:
            return False
      # if service is not enabled in any VRF, then enable service in default VRF
      return serviceEnabled

   return False

class HttpServiceConfig:
   def __init__( self, ctx, service ):
      self.ctx = ctx
      self.service = service
      self.entityManager = ctx.entityManager
      self.serverConfig = ctx.serverConfig
      self.serverStatus = ctx.serverStatus

   def serviceEnabled( self, vrf ):
      return checkServiceEnabled( self.serverConfig, self.service, vrf )

   def externalServerConfig( self, vrf ):
      return ''

   def internalServerConfig( self, vrf ):
      return ''

   def unixDomainSocketServerConfig( self ):
      return ''

   def unixDomainSocketServerEnabled( self ):
      return False

   def getUnixDomainSocket( self ):
      return ''

   def virtualServerConfig( self ):
      return ''
