# Copyright (c) 2009 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

"""This module contains definitions from the IANA Address Family Numbers MIB.  See
<http://www.iana.org/assignments/ianaaddressfamilynumbers-mib>."""

other = 0
ipV4 = 1
ipV6 = 2
nsap = 3
hdlc = 4
bbn1822 = 5
all802 = 6
e163 = 7
e164 = 8
f69 = 9
x121 = 10
ipx = 11
appleTalk = 12
decnetIV = 13
banyanVines = 14
e164withNsap = 15
dns = 16
distinguishedName = 17
asNumber = 18
xtpOverIpv4 = 19
xtpOverIpv6 = 20
xtpNativeModeXTP = 21
fibreChannelWWPN = 22
fibreChannelWWNN = 23
gwid = 24
afi = 25
reserved = 65535

addrFamilyNames = {
   all802 : 'Ethernet',
   ipV4 : 'IPv4',
   ipV6 : 'IPv6',
}

