# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import IdpromTemplates.QsfpDd as QsfpDd # pylint: disable=consider-using-from-import

##################################################
# QSFP-DD and OSFP 400GBASE-ZR
# Id EEPROM taken from Acacia module
##################################################

QsfpDd400gZrLowerPage00 = [
   0x18, 0x41, 0x04, 0x02, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa1,
   0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x11, 0x3e,
   0x81, 0x01, 0x11, 0x3f, 0x81, 0x01, 0x0d, 0x3e,
   0x21, 0x55, 0x11, 0xc5, 0x81, 0x01, 0xff, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x41, 0x11, 0x0f, 0xc2, 0x41, 0x11, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
]
Osfp400gZrLowerPage00 = QsfpDd400gZrLowerPage00[ : ]
Osfp400gZrLowerPage00[ 0 ] = 0x19
# We are making the osfp module not support O-FEC for test coverage purposes
Osfp400gZrLowerPage00[ 98 ] = 0xff
Osfp400gZrLowerPage00[ 103 : 107 ] = [ 0x00 ] * 4

QsfpDd400gZrUpperPage00 = [
   0x18, 0x41, 0x72, 0x69, 0x73, 0x74, 0x61, 0x20,
   0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73,
   0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0xe0, 0x50, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
]
Osfp400gZrUpperPage00 = QsfpDd400gZrUpperPage00[ : ]
Osfp400gZrUpperPage00[ 0 ] = 0x19

##################################################
# QSFP-DD and OSFP 400GBASE-ZRP (ZR+)
# Id EEPROM taken from Acacia module
##################################################
# TODO: When we get real Acacia ZR+ we need to update these
QsfpDd400gZrPLowerPage00 = [
   0x18, 0x41, 0x04, 0x02, 0x01, 0x00, 0x00, 0x00,
   0x01, 0xa0, 0x00, 0x00, 0x00, 0x00, 0x19, 0xed,
   0x83, 0x7d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x3d,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x10, 0x3f, 0x42, 0x41, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x11, 0x3e,
   0x81, 0x01, 0x11, 0x3f, 0x81, 0x01, 0x0d, 0x3e,
   0x21, 0x55, 0x11, 0xc5, 0x81, 0x01, 0x11, 0xc0,
   0x81, 0x01, 0x0d, 0xc0, 0x21, 0x55, 0x0d, 0xc1,
   0x21, 0x55, 0x11, 0xce, 0x81, 0x01, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04,
]
Osfp400gZrPLowerPage00 = QsfpDd400gZrPLowerPage00[ : ]
Osfp400gZrPLowerPage00[ 0 ] = 0x19
QsfpDd400gZrPUpperPage00 = QsfpDd400gZrUpperPage00[ : ]
# Set module power to 24W
QsfpDd400gZrPUpperPage00[ 72 : 74 ] = [ 0xe0, 0x60 ]
Osfp400gZrPUpperPage00 = QsfpDd400gZrPUpperPage00[ : ]
Osfp400gZrPUpperPage00[ 0 ] = 0x19

QsfpDd400gZrPUpperPage01 = [
   0x3d, 0x00, 0x30, 0x31, 0x7f, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x78, 0xea, 0x82, 0x1e, 0x64, 0x04,
   0x79, 0xc0, 0x55, 0xf6, 0x00, 0x00, 0x9c, 0x00,
   0x00, 0xdc, 0x77, 0xc3, 0x07, 0x0f, 0x06, 0x0b,
   0x06, 0x00, 0x0c, 0xb7, 0xff, 0x80, 0x28, 0x79,
   0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
   0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d,
   0xce, 0x21, 0x55, 0x0d, 0xcf, 0x21, 0x55, 0x0d,
   0xc2, 0x21, 0x55, 0x41, 0xc2, 0x41, 0x11, 0x0d,
   0xc4, 0x21, 0x55, 0x41, 0xc4, 0x41, 0x11, 0xff,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8d,
]

QsfpDd400gZrPUpperPage04 = QsfpDd.QsfpDd400gZrUpperPage04[ : ]
QsfpDd400gZrPUpperPage12Bank0 = [ 0 ] * 128

# 400G-ZRP VDM Pages
QsfpDd400gZrPUpperPage2FBank0 = [ 0 ] * 128
# Set number of supported VDM groups to 4
QsfpDd400gZrPUpperPage2FBank0[ 0 ] = 0x3

QsfpDd400gZrPUpperPage20Bank0 = QsfpDd.QsfpDd400gZrUpperPage20Bank0[ : ]
QsfpDd400gZrPUpperPage21Bank0 = QsfpDd.QsfpDd400gZrUpperPage21Bank0[ : ]
QsfpDd400gZrPUpperPage22Bank0 = QsfpDd.QsfpDd400gZrUpperPage22Bank0[ : ]
QsfpDd400gZrPUpperPage23Bank0 = QsfpDd.QsfpDd400gZrUpperPage23Bank0[ : ]

QsfpDd400gZrPUpperPage28Bank0 = [ 0 ] * 128
QsfpDd400gZrPUpperPage28Bank0[ 24 : 32 ] = [ 0x64, 0x00, 0xe7, 0x00,
                                           0x5f, 0x00, 0xec, 0x00 ]
