# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

##################################################
#
# OSFP 400gSr8
# INNOLIGHT T-OS8FNS-H00
# Note: EEPROM is edited to our needs.
##################################################

Osfp400gSr8LowerPage00 = [
   0x19, 0x40, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0xf6,
   0x84, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x11, 0x10,
   0x88, 0x01, 0x0b, 0x09, 0x44, 0x11, 0x0a, 0x07,
   0x11, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
]

Osfp400gSr8UpperPage00 = [
   0x19, 'vn', 'vn', 'vn', 'vn', 'vn', 'vn', 'vn',
   'vn', 'vn', 'vn', 'vn', 'vn', 'vn', 'vn', 'vn',
   'vn', 0x44, 0x7c, 0x7f, 0x54, 0x2d, 0x4f, 0x53,
   0x38, 0x46, 0x4e, 0x53, 0x2d, 0x48, 0x30, 0x30,
   0x20, 0x20, 0x20, 0x20, 0x31, 0x41, 'sn', 'sn',
   'sn', 'sn', 'sn', 'sn', 'sn', 'sn', 'sn', 'sn',
   'sn', 'sn', 'sn', 'sn', 'sn', 'sn', 'dc', 'dc',
   'dc', 'dc', 'dc', 'dc', 'dc', 'dc', 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0xc0, 0x38, 0x00, 0x6a, 0x00, 0x46, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x50, 0x00, 0x00, 0x00, 0x37, 0x72,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
]

Osfp400gSr8UpperPage01 = [
   0xff, 0xff, 0x33, 0x41, 0x00, 0x00, 0x32, 0x23,
   0x00, 0xff, 0x42, 0x68, 0x07, 0xd0, 0x35, 0x00,
   0xff, 0x00, 0x3c, 0x14, 0xff, 0xff, 0x9b, 0x78,
   0x6e, 0xf9, 0x32, 0x12, 0x00, 0x06, 0x06, 0x03,
   0x07, 0x1f, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x01, 0x11, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xef,
]

Osfp400gSr8UpperPage02 = [
   0x50, 0x00, 0xf6, 0x00, 0x4b, 0x00, 0xfb, 0x00,
   0x8e, 0x00, 0x74, 0x00, 0x87, 0x70, 0x7a, 0x48,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x50, 0x00, 0xf6, 0x00, 0x4b, 0x00, 0xfb, 0x00,
   0x50, 0x00, 0xf6, 0x00, 0x4b, 0x00, 0xfb, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x8a, 0x99, 0x11, 0x72, 0x6e, 0x17, 0x15, 0xf7,
   0x1d, 0x4a, 0x08, 0xc8, 0x05, 0xdd, 0x19, 0x63,
   0x7b, 0x86, 0x02, 0x77, 0x62, 0x1e, 0x03, 0xe8,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10,
]

Osfp400gSr8UpperPage10Bank0 = [
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
]

Osfp400gSr8UpperPage11Bank0 = [
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00,
   0x00, 0x21, 0x43, 0x65, 0x87, 0x00, 0x00, 0x10,
   0x32, 0x54, 0x76, 0x67, 0x45, 0x23, 0x01, 0x10,
   0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
]

Osfp400gSr8Cmis3LowerPage00 = [
   0x19, 0x30, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0xf6,
   0x84, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x11, 0x10,
   0x88, 0x01, 0x0b, 0x09, 0x44, 0x11, 0x0a, 0x07,
   0x11, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
]

##################################################
#
# OSFP 400gAr8
# INNOLIGHT        T-OC8FNT-H00
#
# Note: EEPROM is edited to our needs.
# Upper pages are not defined here. We will use
# 400gSr8 upper pages for now.
##################################################

Osfp400gAr8LowerPage00 = [
   0x19, 0x06, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0xb4,
   0x7c, 0xb7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x11, 0x01,
   0x88, 0x01, 0x0f, 0x01, 0x44, 0x11, 0xff, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
]

Osfp400gAr8UpperPage00 = [
   0x11, 'vn', 'vn', 'vn', 'vn', 'vn', 'vn', 'vn',
   'vn', 'vn', 'vn', 'vn', 'vn', 'vn', 'vn', 'vn',
   'vn', 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0xff, 0xff, 0x00, 0xff, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x3f, 0xb9, 0x30, 0x31, 'sn', 'sn',
   'sn', 'sn', 'sn', 'sn', 'sn', 'sn', 'sn', 'sn',
   'sn', 'sn', 'sn', 'sn', 'sn', 'sn', 'dc', 'dc',
   'dc', 'dc', 'dc', 'dc', 'dc', 'dc', 0x0e, 0xc3,
   0x0e, 0xc3, 0x0e, 0xc3, 0x4d, 0x73, 0x4a, 0x25,
   0x4f, 0x03, 0x4b, 0x7a, 0x47, 0x87, 0x4b, 0xfa,
   0x4b, 0x5d, 0x48, 0x46, 0x00, 0x00, 0x00, 0x00,
   0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff,
   0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
]

Osfp400gAr8UpperPage01 = [
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01
]

Osfp400gAr8UpperPage02 = [
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
]

Osfp400gCra8LowerPage00 = Osfp400gAr8LowerPage00[ : ]
Osfp400gCra8LowerPage00[ 86 ] = 0x0D # 100G-2
Osfp400gCra8LowerPage00[ 87 ] = 0x01 # Active Cable assembly with BER < 10^-12
Osfp400gCra8LowerPage00[ 88 ] = 0x22 # 2 host lanes, 2 media lanes
Osfp400gCra8LowerPage00[ 89 ] = 0x55 # Application starts at lanes 1,3,5,7 host
Osfp400gCra8LowerPage00[ 90 ] = 0xFF # End of list
# Cra8 changes mediaInterfaceTech
Osfp400gCra8UpperPage00 = Osfp400gAr8UpperPage00[ : ]
Osfp400gCra8UpperPage00[ 84 ] = 0xA
Osfp400gCra8UpperPage01 = [ 0x00 ] * 128
Osfp400gCra8UpperPage01[ 48 ] = 0x55 # Application starts at lanes 1,3,5,7 media
Osfp400gCra8UpperPage01[ 127 ] = 0x55 # Checksum

##################################################
#
# OSFP 400g2Fr4
# Arista Networks  OSFP-400G-2FR4   INIAI4850208
##################################################

Osfp400g2Fr4LowerPage00 = [
   0x19, 0x40, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00,
   0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x29, 0xaa,
   0x84, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x0f, 0x18,
   0x44, 0x11, 0x0b, 0x10, 0x44, 0x11, 0x06, 0x09,
   0x44, 0x11, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
]

Osfp400g2Fr4UpperPage00 = [
   0x19, 0x41, 0x72, 0x69, 0x73, 0x74, 0x61, 0x20,
   0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73,
   0x20, 0x00, 0x1c, 0x73, 0x4f, 0x53, 0x46, 0x50,
   0x2d, 0x34, 0x30, 0x30, 0x47, 0x2d, 0x32, 0x46,
   0x52, 0x34, 0x20, 0x20, 0x32, 0x30, 0x49, 0x4e,
   0x49, 0x41, 0x4f, 0x34, 0x38, 0x35, 0x30, 0x32,
   0x33, 0x35, 0x20, 0x20, 0x20, 0x20, 0x31, 0x38,
   0x30, 0x34, 0x30, 0x33, 0x20, 0x20, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0xa0, 0x30, 0x00, 0x25, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x43, 0xc6, 0x9d, 0x88
]

Osfp400g2Fr4UpperPage01 = [
   0x00, 0x00, 0x35, 0x41, 0x42, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x65, 0xa4, 0x05, 0x14, 0x24, 0x04,
   0x44, 0x20, 0x3c, 0x14, 0x00, 0x00, 0x9d, 0x78,
   0x6e, 0x00, 0x00, 0x02, 0x00, 0x06, 0x06, 0x03,
   0x07, 0x09, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x11, 0x11, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8e
]

Osfp400g2Fr4UpperPage02 = [
   0x46, 0x00, 0x0a, 0x00, 0x41, 0x00, 0x0f, 0x00,
   0x8c, 0xa0, 0x75, 0x30, 0x87, 0x55, 0x7a, 0x75,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x57, 0x88, 0x0c, 0x5a, 0x4e, 0x01, 0x0d, 0xdc,
   0xff, 0xdc, 0x44, 0x5a, 0xfb, 0xf4, 0x48, 0x45,
   0x7b, 0x86, 0x02, 0x77, 0x62, 0x1e, 0x03, 0xe8,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x93
]

Osfp400g2Fr4UpperPage10Bank0 = [
   0xff, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x11, 0x11, 0x11, 0x11, 0x19, 0x19, 0x19,
   0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10,
   0x28, 0x28, 0x28, 0x28, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
]

Osfp400g2Fr4UpperPage11Bank0 = [
   0x44, 0x44, 0x44, 0x44, 0x00, 0x00, 0xff, 0x00,
   0xff, 0xfb, 0x00, 0x00, 0xff, 0x00, 0xff, 0x00,
   0xff, 0x00, 0xff, 0xff, 0xff, 0x00, 0xff, 0x00,
   0xff, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01,
   0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01,
   0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01,
   0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01,
   0x00, 0x01, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
   0x11, 0x11, 0x19, 0x19, 0x19, 0x19, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x11, 0x21, 0x31, 0x41, 0x12, 0x22, 0x32, 0x42,
   0x11, 0x21, 0x31, 0x41, 0x12, 0x22, 0x32, 0x42
]

##################################################
#
# OSFP POLS AmpZr
# II-VI            60P010001        P01000004
##################################################
OsfpAmpZrLowerPage00 = [
   0x19, 0x40, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0xed,
   0xff, 0xff, 0x00, 0x00, 0x22, 0x1d, 0x21, 0xe9,
   0x00, 0x00, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0xff, 0xff, 0x02, 0x00, 0xC2,
   0x02, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
]

# TODO: Fake upper page data for POLS
#       Will update them once we have a sample
OsfpAmpZrUpperPage00 = [
   0x19, 'vn', 'vn', 'vn', 'vn', 'vn', 'vn', 'vn',
   'vn', 'vn', 'vn', 'vn', 'vn', 'vn', 'vn', 'vn',
   'vn', 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0xff, 0xff, 0x00, 0xff, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x3f, 0xb9, 0x30, 0x31, 'sn', 'sn',
   'sn', 'sn', 'sn', 'sn', 'sn', 'sn', 'sn', 'sn',
   'sn', 'sn', 'sn', 'sn', 'sn', 'sn', 'dc', 'dc',
   'dc', 'dc', 'dc', 'dc', 'dc', 'dc', 0x0e, 0xc3,
   0x0e, 0xc3, 0x0e, 0xc3, 0x4d, 0x73, 0x4a, 0x25,
   0x4f, 0x03, 0x4b, 0x7a, 0x47, 0x87, 0x4b, 0xfa,
   0x4b, 0x5d, 0x48, 0x46, 0x00, 0x00, 0x00, 0x00,
   0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x03,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff,
   0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
]

# The diagnostic pages are not implemented for this module.
# Page 03 is not implemented.
OsfpAmpZrUpperPage01 = [
   0x00, 0x00, 0x35, 0x41, 0x42, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x65, 0xa4, 0x05, 0x14, 0x00, 0x04,
   0x44, 0x20, 0x3c, 0x14, 0x00, 0x00, 0x9d, 0x78,
   0x6e, 0x00, 0x00, 0x02, 0x00, 0x06, 0x06, 0x03,
   0x07, 0x09, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x11, 0x11, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6a
]

# Currently, TX bias thresholds are arbitrary numbers because II-VI has not
# implemented current monitoring yet. Aux2 thresholds are inflated by 1C
# to differentiate with Aux3 thresholds in btest.
OsfpAmpZrUpperPage02 = [
   0x46, 0x00, 0xfb, 0x00, 0x41, 0x00, 0x00, 0x00,
   0x87, 0x5a, 0x7a, 0x76, 0x83, 0x7c, 0x7e, 0x54,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x4c, 0x00, 0x01, 0x00, 0x47, 0x00, 0x06, 0x00,
   0x4b, 0x00, 0x00, 0x00, 0x46, 0x00, 0x05, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0xf4, 0x24, 0x01, 0x38, 0xdb, 0xba, 0x04, 0xe2,
   0x0b, 0xb8, 0x00, 0xfa, 0x07, 0xd0, 0x01, 0xf4,
   0x93, 0x76, 0x00, 0x08, 0x75, 0x30, 0x00, 0x0f,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf4, 0x24,
   0x01, 0x38, 0xdb, 0xba, 0x04, 0xe2, 0x75, 0x30,
   0x09, 0xc4, 0x4e, 0x20, 0x13, 0x88, 0x00, 0xee,
   0x00, 0x05, 0x00, 0xbc, 0x00, 0x0a, 0x02, 0x70,
]

# Set some monitors to arbitrary values for use in breadth tests. These values
# were taken from an operating module.
OsfpAmpZrUpperPage11Bank0 = [ 0 ] * 128
OsfpAmpZrUpperPage11Bank0[ 0 ] = 0x44
OsfpAmpZrUpperPage11Bank0[ 26 : 28 ] = [ 0x7b, 0x0b ]
OsfpAmpZrUpperPage11Bank0[ 28 : 30 ] = [ 0x79, 0x70 ]
OsfpAmpZrUpperPage11Bank0[ 58 : 60 ] = [ 0x01, 0x0d ]
OsfpAmpZrUpperPage11Bank0[ 60 : 62 ] = [ 0x00, 0x97 ]
OsfpAmpZrUpperPage11Bank0[ 78 : 80 ] = [ 0x10, 0x10 ]

OsfpAmpZrUpperPageC0 = [ 0 ] * 128

OsfpAmpZrUpperPageC1 = [ 0 ] * 128

OsfpAmpZrUpperPageD0 = [ 0 ] * 128

OsfpAmpZrUpperPageD1 = [ 0 ] * 128

OsfpAmpZrUpperPageD8 = [ 0 ] * 128

OsfpAmpZrUpperPageD9 = [ 0 ] * 128

##################################################
#
# Arista Networks  OSFP-400G-DR4    XKT193800012
# OSFP 400G DR4
##################################################

Osfp400gDr4LowerPage00 = [
   0x19, 0x40, 0x00, 0x06, 0x08, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0x1a,
   0x7f, 0xa7, 0x00, 0x00, 0x37, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x11, 0x1c,
   0x84, 0x01, 0x0d, 0x14, 0x21, 0x55, 0xff, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
]

Osfp400gDr4UpperPage00 = [
   0x19, 0x41, 0x72, 0x69, 0x73, 0x74, 0x61, 0x20,
   0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73,
   0x20, 0x00, 0x1c, 0x73, 0x4f, 0x53, 0x46, 0x50,
   0x2d, 0x34, 0x30, 0x30, 0x47, 0x2d, 0x44, 0x52,
   0x34, 0x20, 0x20, 0x20, 0x32, 0x30, 0x58, 0x4b,
   0x54, 0x31, 0x39, 0x33, 0x38, 0x30, 0x30, 0x30,
   0x31, 0x32, 0x20, 0x20, 0x20, 0x20, 0x31, 0x39,
   0x30, 0x39, 0x32, 0x31, 0x20, 0x20, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x80, 0x28, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xf0, 0x00, 0x06, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0xd5, 0xd8, 0x27, 0xdd,
]

Osfp400gDr4UpperPage01 = [
   0x01, 0x00, 0x01, 0x00, 0x05, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x66, 0x6c, 0x05, 0x14, 0x04, 0xdf,
   0x77, 0xc0, 0x46, 0x00, 0x00, 0x00, 0x9d, 0x18,
   0x00, 0xf0, 0x77, 0x2f, 0x03, 0x0f, 0x06, 0x0b,
   0x07, 0x09, 0x1d, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x01, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc,
]

Osfp400gDr4UpperPage02 = [
   0x4b, 0x00, 0xfb, 0x00, 0x46, 0x00, 0x00, 0x00,
   0x8d, 0xcc, 0x77, 0x24, 0x87, 0x5a, 0x7a, 0x76,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x48, 0x00, 0x1c, 0x00, 0x46, 0x00, 0x1e, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x8a, 0x99, 0x0f, 0xea, 0x6e, 0x18, 0x14, 0x09,
   0xfd, 0xe8, 0x13, 0x88, 0xf4, 0x24, 0x1d, 0x4c,
   0x8a, 0x99, 0x05, 0x08, 0x6e, 0x18, 0x07, 0xfa,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x90,
]

Osfp400gDr4UpperPage10Bank0 = [
   0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x21, 0x21, 0x25, 0x25, 0x29, 0x29, 0x2d,
   0x2d, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0xff, 0xff, 0x55, 0x55, 0x55, 0x55, 0x00, 0x00,
   0x00, 0x00, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10,
   0x10, 0x10, 0x10, 0x10, 0xff, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0xff, 0xff, 0x55, 0x55, 0x55,
   0x55, 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x22,
   0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
]

Osfp400gDr4UpperPage11Bank0 = [
   0x44, 0x44, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x3d, 0x01, 0x3c, 0x75, 0x2a, 0x62,
   0x2d, 0x4e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x93, 0x44, 0x9c, 0xd6, 0xa6, 0xcc,
   0xa6, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x5b, 0xf2, 0x3a, 0xce, 0x33, 0x02,
   0x4d, 0xda, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x11, 0x11, 0x11, 0x11, 0x21, 0x21,
   0x25, 0x25, 0x29, 0x29, 0x2d, 0x2d, 0xff, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x55,
   0x55, 0x55, 0x55, 0x00, 0x00, 0x00, 0x00, 0x22,
   0x22, 0x22, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x11, 0x12, 0x13, 0x14, 0x00, 0x00, 0x00, 0x00,
   0x11, 0x12, 0x13, 0x14, 0x00, 0x00, 0x00, 0x00,
]

Osfp400gXdr4UpperPage01 = Osfp400gDr4UpperPage01[ : ]
# Set link length (SMF) for Xdr4 to 2 km
Osfp400gXdr4UpperPage01[ 4 ] = 0x42
# Update checksum
Osfp400gXdr4UpperPage01[ 127 ] = 0x39

# Fr4
Osfp400gFr4LowerPage00 = Osfp400gDr4LowerPage00[ : ]
# Change media interface code for ApSel 1 to 400GBASE-FR4
Osfp400gFr4LowerPage00[ 87 ] = 0x1d
Osfp400gFr4LowerPage00[ 90 ] = 0xff
# Add an ApSel2 for 1x200G-4 mode (this is a fragmented application since it only
# uses 4 host lanes and 4 media lanes )
Osfp400gFr4LowerPage00[ 90 ] = 0x0f
Osfp400gFr4LowerPage00[ 91 ] = 0x18
Osfp400gFr4LowerPage00[ 92 ] = 0x44
Osfp400gFr4LowerPage00[ 93 ] = 0x01
Osfp400gFr4LowerPage00[ 94 ] = 0xff

# 4x100G-DR
Osfp4x100gDrLowerPage00 = Osfp400gDr4LowerPage00[ : ]
# Swap ApSels 1 and 2
Osfp4x100gDrLowerPage00[ 86 ] = 0x0d
Osfp4x100gDrLowerPage00[ 87 ] = 0x14
Osfp4x100gDrLowerPage00[ 88 ] = 0x21
Osfp4x100gDrLowerPage00[ 89 ] = 0x55
Osfp4x100gDrLowerPage00[ 90 ] = 0x11
Osfp4x100gDrLowerPage00[ 91 ] = 0x1c
Osfp4x100gDrLowerPage00[ 92 ] = 0x84
Osfp4x100gDrLowerPage00[ 93 ] = 0x01
Osfp4x100gDrUpperPage01 = Osfp400gDr4UpperPage01[ : ]
# Swap media lane assignment for the ApSels
Osfp4x100gDrUpperPage01[ 48 ] = 0x0f
Osfp4x100gDrUpperPage01[ 49 ] = 0x01

# Plr4
Osfp400gPlr4LowerPage00 = Osfp400gDr4LowerPage00[ : ]
# Change media interface code for ApSel 1 to Unknown
Osfp400gPlr4LowerPage00[ 87 ] = 0x00
# Change media interface code for ApSel 2 to 100GBASE-LR
Osfp400gPlr4LowerPage00[ 91 ] = 0x16

# Ar4
# Lower Page 00h
Osfp400gAr4LowerPage00 = Osfp400gDr4LowerPage00[ : ]
# Reserved
Osfp400gAr4LowerPage00[ 12 ] = 0x00
# Custom
Osfp400gAr4LowerPage00[ 13 ] = 0x00
# Applications
Osfp400gAr4LowerPage00[ 85 ] = 0x04 # Active Cables
Osfp400gAr4LowerPage00[ 86 : 90 ] = [ 0x11, 0x03, 0x84, 0x01 ]  # Apsel1
Osfp400gAr4LowerPage00[ 90 : 94 ] = [ 0x0f, 0x03, 0x42, 0x11 ]  # Apsel2
Osfp400gAr4LowerPage00[ 94 : 99 ] = [ 0x0d, 0x03, 0x21, 0x55, 0xff ]  # Apsel 3

# Upper Page 01h
Osfp400gAr4UpperPage00 = Osfp400gDr4UpperPage00[ : ]
# Vendor PN
Osfp400gAr4UpperPage00[ 20 : 36 ] = "A-O400-Q400-50M ".encode( "ascii" )
# Revision 40X
Osfp400gAr4UpperPage00[ 36 : 39 ] = [ 0x34, 0x30, 0x58 ]
# Cable Assembly Length: Length multiplier field/base Length field
Osfp400gAr4UpperPage00[ 74 : 76 ] = [ 0x72, 0x23 ]

# Upper Page 01h
Osfp400gAr4UpperPage01 = Osfp400gDr4UpperPage01[ : ]
# Media Lane asAssignment options
Osfp400gAr4UpperPage01[ 48 : 52 ] = [ 0x01, 0x05, 0x0F, 0x00 ]
# Checksum
Osfp400gAr4UpperPage01[ 127 ] = 0x01

##################################################
#
# OSFP Id EEPROM definitions
#
# CAB-O-O-400G-1M
#   - CMIS 3.0 compliant
#   - supports 400kHz TWI access
#
##################################################

Osfp400gCr8LowerPage00 = [
   0x19, 0x30, 0x80, 0x03, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x1D, 0x01,
   0x88, 0x01, 0x1C, 0x01, 0x44, 0x11, 0x1B, 0x01,
   0x22, 0x55, 0x18, 0x01, 0x11, 0xFF, 0x1A, 0x01,
   0x44, 0x11, 0x16, 0x01, 0x11, 0xFF, 0x17, 0x01,
   0x44, 0x11, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
]

Osfp400gCr8UpperPage00 = [
   0x19, 'vn', 'vn', 'vn', 'vn', 'vn', 'vn', 'vn',
   'vn', 'vn', 'vn', 'vn', 'vn', 'vn', 'vn', 'vn',
   'vn', 0x00, 0x1C, 0x73, 0x43, 0x41, 0x42, 0x2D,
   0x4F, 0x2D, 0x4F, 0x2D, 0x34, 0x30, 0x30, 0x47,
   0x2D, 0x31, 0x4D, 0x20, 'sn', 'sn', 'sn', 'sn',
   'sn', 'sn', 'sn', 'sn', 'sn', 'sn', 'sn', 'sn',
   'sn', 'sn', 'sn', 'sn', 'dc', 'dc', 'dc', 'dc',
   'dc', 'dc', 'dc', 'dc', 0x20, 0x20, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x41, 0x23, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x02, 0x0A, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
]

##################################################
#
# OSFP Id EEPROM definitions
#
# CAB-O-O-400G-1M
#   - CMIS 4.0 compliant
#   - supports 400kHz TWI access
#
##################################################

Cmis4Osfp400gCr8LowerPage00 = [
   0x19, 0x40, 0x80, 0x03, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x1D, 0x01,
   0x88, 0x01, 0x1C, 0x01, 0x44, 0x11, 0x1B, 0x01,
   0x22, 0x55, 0x18, 0x01, 0x11, 0xFF, 0x1A, 0x01,
   0x44, 0x11, 0x16, 0x01, 0x11, 0xFF, 0x17, 0x01,
   0x44, 0x11, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
]

Cmis4Osfp400gCr8UpperPage00 = [
   0x19, 'vn', 'vn', 'vn', 'vn', 'vn', 'vn', 'vn',
   'vn', 'vn', 'vn', 'vn', 'vn', 'vn', 'vn', 'vn',
   'vn', 0x00, 0x1C, 0x73, 0x43, 0x41, 0x42, 0x2D,
   0x4F, 0x2D, 0x4F, 0x2D, 0x34, 0x30, 0x30, 0x47,
   0x2D, 0x31, 0x4D, 0x20, 'sn', 'sn', 'sn', 'sn',
   'sn', 'sn', 'sn', 'sn', 'sn', 'sn', 'sn', 'sn',
   'sn', 'sn', 'sn', 'sn', 'dc', 'dc', 'dc', 'dc',
   'dc', 'dc', 'dc', 'dc', 0x20, 0x20, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x41, 0x23, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x02, 0x0A, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
]

##################################################
# OSFP Google
# Id EEPROM taken from Google's supplied module
##################################################

GoogleOM8FNTUpperPage00 = [
   0x19, 0x49, 0x4e, 0x4e, 0x4f, 0x4c, 0x49, 0x47,
   0x48, 0x54, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
   0x20, 0x44, 0x7c, 0x7f, 0x54, 0x2d, 0x4f, 0x4d,
   0x38, 0x46, 0x4e, 0x54, 0x2d, 0x48, 0x30, 0x31,
   0x20, 0x20, 0x20, 0x20, 0x31, 0x42, 0x49, 0x4e,
   0x49, 0x42, 0x4b, 0x38, 0x31, 0x36, 0x33, 0x30,
   0x37, 0x30, 0x20, 0x20, 0x20, 0x20, 0x31, 0x38,
   0x30, 0x39, 0x32, 0x36, 0x30, 0x36, 0x20, 0x20,
   0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
   0xa0, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf6, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
]

GoogleOsfp8x10gLrLowerPage00 = [
   0x19, 0x40, 0x04, 0x03, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0xd2,
   0x82, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x79,
   0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x0e, 0xff,
   0x88, 0x01, 0x0b, 0x0f, 0x44, 0x11, 0x08, 0xfe,
   0x22, 0x55, 0x05, 0x07, 0x11, 0xff, 0x04, 0x04,
   0x11, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02,
]

GoogleOsfp8x10gLrUpperPage00 = [
   0x19, 0x49, 0x4e, 0x4e, 0x4f, 0x4c, 0x49, 0x47,
   0x48, 0x54, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
   0x20, 0x44, 0x7c, 0x7f, 0x54, 0x2d, 0x4f, 0x50,
   0x38, 0x5a, 0x44, 0x54, 0x2d, 0x4e, 0x30, 0x30,
   0x20, 0x20, 0x20, 0x20, 0x31, 0x45, 0x49, 0x4e,
   0x4f, 0x41, 0x54, 0x56, 0x33, 0x36, 0x30, 0x30,
   0x33, 0x33, 0x20, 0x20, 0x20, 0x20, 0x32, 0x34,
   0x30, 0x35, 0x32, 0x31, 0x20, 0x20, 0x20, 0x20,
   0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
   0x40, 0x1a, 0x00, 0x28, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xff, 0x00, 0x04, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb2, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
]

##################################################
#
# OSFP Id EEPROM definitions
#
# CAB-O-O-800G-1M
#   - CMIS 4.0 compliant
#   - supports 800kHz TWI access
#
##################################################

Cmis4Osfp800gCr8LowerPage00 = [
   0x19, 0x40, 0x80, 0x07, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x49, 0x01,
   0x88, 0x01, 0x1D, 0x01, 0x88, 0x01, 0x1C, 0x01,
   0x44, 0x11, 0x1B, 0x01, 0x22, 0x55, 0x18, 0x01,
   0x11, 0xFF, 0x1A, 0x01, 0x44, 0x11, 0x16, 0x01,
   0x11, 0xFF, 0x17, 0x01, 0x44, 0x11, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
]

Cmis4Osfp800gCr8UpperPage00 = [
   0x19, 0x41, 0x72, 0x69, 0x73, 0x74, 0x61, 0x20,
   0x4E, 0x65, 0x74, 0x77, 0x6F, 0x72, 0x6B, 0x73,
   0x20, 0x00, 0x1C, 0x73, 0x43, 0x41, 0x42, 0x2D,
   0x4F, 0x2D, 0x4F, 0x2D, 0x38, 0x30, 0x30, 0x47,
   0x2D, 0x31, 0x4D, 0x20, 0x34, 0x30, 'sn', 'sn',
   'sn', 'sn', 'sn', 'sn', 'sn', 'sn', 'sn', 'sn',
   'sn', 'sn', 'sn', 'sn', 'sn', 'sn', 'dc', 'dc',
   'dc', 'dc', 'dc', 'dc', 'dc', 'dc', 0x20, 0x20,
   0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
   0x00, 0x00, 0x41, 0x23, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x02, 0x0A, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
]

##################################################
# OSFP 2x400GBASE-CR4, runs on both lane 0 and lane 4,
# we identify the module as 800GBASE-CR8.
##################################################

Osfp2x400gCr4LowerPage00 = [
   0x19, 0x40, 0x80, 0x03, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x48, 0x01,
   0x44, 0x11, 0x1C, 0x01, 0x44, 0x01, 0x47, 0x01,
   0x22, 0x05, 0x18, 0x01, 0x11, 0x0F, 0x1A, 0x01,
   0x44, 0x01, 0x15, 0x01, 0x11, 0x0F, 0x17, 0x01,
   0x44, 0x11, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
]

##################################################
#
# OSFP Id EEPROM definitions
#
# 800GBASE-2FR4
#   - CMIS 5.0 compliant
#   - supports 400kHz TWI access
#
##################################################

Osfp800g2Fr4LowerPage00 = [
   0x19, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x50, 0x1d,
   0x44, 0x11, 0x52, 0x00, 0x88, 0x01, 0x4e, 0x00,
   0x22, 0x55, 0x4c, 0x15, 0x11, 0xff, 0x11, 0x1a,
   0x88, 0x01, 0x0f, 0x18, 0x44, 0x11, 0x0d, 0x00,
   0x22, 0x55, 0x0a, 0x0b, 0x11, 0xff, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
]

Osfp800g2Fr4UpperPage00 = [
   0x19, 'vn', 'vn', 'vn', 'vn', 'vn', 'vn', 'vn',
   'vn', 'vn', 'vn', 'vn', 'vn', 'vn', 'vn', 'vn',
   'vn', 0x00, 0x1c, 0x73, 0x4f, 0x53, 0x46, 0x50,
   0x2d, 0x38, 0x30, 0x30, 0x47, 0x2d, 0x32, 0x46,
   0x52, 0x34, 0x20, 0x20, 0x34, 0x30, 'sn', 'sn',
   'sn', 'sn', 'sn', 'sn', 'sn', 'sn', 'sn', 'sn',
   'sn', 'sn', 'sn', 'sn', 'sn', 'sn', 'dc', 'dc',
   'dc', 'dc', 'dc', 'dc', 'dc', 'dc', 0x20, 0x20,
   0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
   0x00, 0x00, 0x00, 0x25, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0xcc, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
]

Osfp800g2Fr4UpperPage01 = [
   0x00, 0x00, 0x00, 0x00, 0x42, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x65, 0xa4, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x11, 0x01, 0x55, 0xff, 0x01, 0x11, 0x55, 0xff,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18,
]

Osfp800g2Fr4UpperPage02 = [
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
]
##################################################
#
# OSFP Id EEPROM definitions
#
# 3rd Party 800GBASE-2FR4:
# Apsel1: Media Interface ID undefined
# ApSel2: Media Interface 1D is 400G-FR4
#
##################################################
Osfp800g2Fr4LowerPage003rdParty = Osfp800g2Fr4LowerPage00[ : ]
Osfp800g2Fr4LowerPage003rdParty[ 86 : 94 ] = [ 0x52, 0x00, 0x88, 0x01, # Apsel1
                                               0x50, 0x1d, 0x44, 0x11 ] # Apsel2

##################################################
#
# OSFP Id EEPROM definitions
#
# Finisar 800GBASE-2FR4:
#
##################################################
Osfp800g2Fr4FinisarLowerPage00 = Osfp800g2Fr4LowerPage003rdParty[ : ]
Osfp800g2Fr4FinisarLowerPage00[ 87 ] = 0xD0

##################################################
#
# OSFP Id EEPROM definitions
#
# 800GBASE-DR8
#   - CMIS 5.0 compliant
#   - supports 400kHz TWI access
#
##################################################

Osfp800gDr8LowerPage00 = [
   0x19, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x52, 0xd0,
   0x88, 0x01, 0x50, 0x1c, 0x44, 0x11, 0x4e, 0x00,
   0x22, 0x55, 0x4c, 0x14, 0x11, 0xff, 0x11, 0x00,
   0x88, 0x01, 0x0f, 0x17, 0x44, 0x11, 0x0d, 0x00,
   0x22, 0x55, 0x0a, 0x00, 0x11, 0xff, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
]

Osfp800gDr8UpperPage00 = [
   0x19, 'vn', 'vn', 'vn', 'vn', 'vn', 'vn', 'vn',
   'vn', 'vn', 'vn', 'vn', 'vn', 'vn', 'vn', 'vn',
   'vn', 0x00, 0x1c, 0x73, 0x4f, 0x53, 0x46, 0x50,
   0x2d, 0x38, 0x30, 0x30, 0x47, 0x2d, 0x32, 0x46,
   0x52, 0x34, 0x20, 0x20, 0x34, 0x30, 'sn', 'sn',
   'sn', 'sn', 'sn', 'sn', 'sn', 'sn', 'sn', 'sn',
   'sn', 'sn', 'sn', 'sn', 'sn', 'sn', 'dc', 'dc',
   'dc', 'dc', 'dc', 'dc', 'dc', 'dc', 0x20, 0x20,
   0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
   0x00, 0x00, 0x00, 0x28, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0xcc, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
]

Osfp800gDr8UpperPage01 = [
   0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x65, 0xa4, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x01, 0x11, 0x55, 0xff, 0x01, 0x11, 0x55, 0xff,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xdb,
]

Osfp800gDr8UpperPage02 = [
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
]

##################################################
#
# WTD OSFP Id EEPROM definitions
# This module is only used for the XcvrEepromDecodeCliTest
#
# 800GBASE-DR8
#
##################################################
WtdOsfp800gDr8LowerPage00 = [
   0x19, 0x52, 0x04, 0x07, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3b, 0xbe,
   0x80, 0xd5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x01, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x06,
   0x13, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x42, 0x00,
   0x44, 0x59, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x51, 0x56,
   0x88, 0x01, 0x4f, 0x1c, 0x44, 0x11, 0x0f, 0x17,
   0x44, 0x11, 0x00, 0x0f, 0x44, 0x11, 0xff, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02,
]

WtdOsfp800gDr8UpperPage00 = [
   0x19, 0x57, 0x54, 0x44, 0x20, 0x20, 0x20, 0x20,
   0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
   0x20, 0x00, 0x1c, 0xad, 0x4f, 0x54, 0x4f, 0x20,
   0x30, 0x30, 0x30, 0x30, 0x32, 0x20, 0x30, 0x35,
   0x20, 0x30, 0x31, 0x20, 0x31, 0x30, 0x4d, 0x46,
   0x32, 0x34, 0x31, 0x32, 0x30, 0x30, 0x33, 0x38,
   0x30, 0x30, 0x35, 0x34, 0x20, 0x20, 0x32, 0x34,
   0x30, 0x33, 0x32, 0x32, 0x30, 0x30, 0x20, 0x20,
   0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
   0xe0, 0x40, 0x00, 0x7f, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9c, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
]

WtdOsfp800gDr8UpperPage01 = [
   0x06, 0x13, 0x01, 0x00, 0x42, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x66, 0x6c, 0x05, 0x14, 0x64, 0xf0,
   0x58, 0x03, 0x46, 0x00, 0x00, 0x00, 0x9d, 0x38,
   0x00, 0xfa, 0x77, 0x3b, 0x03, 0x07, 0x06, 0x03,
   0x0f, 0x09, 0x1d, 0x77, 0x0f, 0x84, 0x00, 0x57,
   0x58, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x01, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10,
   0x01, 0x06, 0xef, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xdf,
]

WtdOsfp800gDr8UpperPage02 = [
   0x50, 0x00, 0xf6, 0x00, 0x46, 0x00, 0x00, 0x00,
   0x8d, 0xcc, 0x74, 0x04, 0x87, 0x5a, 0x7a, 0x76,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x9b, 0x83, 0x07, 0xfa, 0x62, 0x1f, 0x14, 0x09,
   0x75, 0x30, 0x0e, 0xa6, 0x70, 0x4e, 0x09, 0xc4,
   0x9b, 0x83, 0x03, 0x2d, 0x62, 0x1f, 0x07, 0xfa,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9f,
]

##################################################
#
# INNOLIGHT OSFP Id EEPROM definitions
#
# 800GBASE-DR8-2 (800GBASE-XDR8)
#
##################################################
InnolightOsfp800gXdr8LowerPage00 = [
   0x19, 0x52, 0x04, 0x07, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xa0, 0x00, 0x00, 0x00, 0x37, 0x14,
   0x84, 0x08, 0xe8, 0x48, 0x36, 0xfd, 0x36, 0xfd,
   0xe7, 0xb9, 0x20, 0x00, 0x00, 0x00, 0x01, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4f,
   0xb0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x52, 0x57,
   0x88, 0x01, 0x50, 0x55, 0x44, 0x11, 0x0f, 0x17,
   0x44, 0x11, 0x0b, 0x0f, 0x44, 0x11, 0xff, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02,
]

InnolightOsfp800gXdr8UpperPage00 = [
   0x19, 0x49, 0x4e, 0x4e, 0x4f, 0x4c, 0x49, 0x47,
   0x48, 0x54, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
   0x20, 0x44, 0x7c, 0x7f, 0x50, 0x2d, 0x4f, 0x50,
   0x38, 0x43, 0x4e, 0x54, 0x30, 0x33, 0x50, 0x30,
   0x2d, 0x4e, 0x30, 0x30, 0x31, 0x41, 0x49, 0x4e,
   0x4f, 0x41, 0x55, 0x34, 0x37, 0x33, 0x30, 0x30,
   0x32, 0x31, 0x20, 0x20, 0x20, 0x20, 0x32, 0x34,
   0x30, 0x35, 0x32, 0x37, 0x20, 0x20, 0x20, 0x20,
   0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
   0xe0, 0x40, 0x00, 0x7f, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
]

InnolightOsfp800gXdr8UpperPage01 = [
   0x00, 0x00, 0x01, 0x0a, 0x42, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x66, 0x6c, 0x05, 0x14, 0x64, 0x00,
   0x68, 0xe1, 0x46, 0x00, 0x00, 0x00, 0x9d, 0x18,
   0x00, 0xfc, 0x77, 0x2f, 0x07, 0x07, 0x06, 0x3f,
   0x07, 0x09, 0x3d, 0x57, 0x0f, 0x8c, 0x9e, 0x48,
   0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x01, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10,
   0x61, 0x07, 0x95, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x83,
]

InnolightOsfp800gXdr8UpperPage02 = [
   0x50, 0x00, 0xf6, 0x00, 0x46, 0x00, 0x00, 0x00,
   0x8d, 0xcc, 0x74, 0x04, 0x87, 0x5a, 0x7a, 0x76,
   0x7f, 0xff, 0x80, 0x01, 0x72, 0xa0, 0x8d, 0x00,
   0x46, 0x00, 0x05, 0x00, 0x43, 0x00, 0x0a, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x9b, 0x82, 0x07, 0xf9, 0x62, 0x1e, 0x14, 0x08,
   0xea, 0x60, 0x13, 0x88, 0xe0, 0x9c, 0x1d, 0x4c,
   0x9b, 0x82, 0x03, 0x2c, 0x62, 0x1e, 0x07, 0xf9,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb3,
]

##################################################
#
# OSFP Id EEPROM definitions
#
# 800GBASE-XDR8
#   - CMIS 5.0 compliant
#   - supports 400kHz TWI access
#
##################################################
Osfp800gXdr8LowerPage00 = Osfp800gDr8LowerPage00[ : ]
Osfp800gXdr8LowerPage00[ 86 : 103 ] = [ 0x52, 0x00, 0x88, 0x01, # Apsel1
                                        0x50, 0x1c, 0x44, 0x11, # Apsel2
                                        0x4e, 0x00, 0x22, 0x55, # Apsel3
                                        0x4c, 0x15, 0x11, 0xff, # Apsel4
                                        0xff ]
Osfp800gXdr8UpperPage00 = Osfp800gDr8UpperPage00[ : ]
Osfp800gXdr8UpperPage01 = Osfp800gDr8UpperPage01[ : ]
Osfp800gXdr8UpperPage01[ 4 ] = 0x42 # Set Length multipler / Base length SMF to 2km
Osfp800gXdr8UpperPage01[ 127 ] = 0x18 # checksum
Osfp800gXdr8UpperPage02 = Osfp800gDr8UpperPage02[ : ]

##################################################
#
# OSFP Id EEPROM definitions
#
# 800GBASE-2LR4
#   - CMIS 5.0 compliant
#   - supports 400kHz TWI access
#
##################################################
# Lower Page 00h
Osfp800g2lr4LowerPage00 = Osfp800gXdr8LowerPage00[ : ]
# Host / Media Interface ID Apps
Osfp800g2lr4LowerPage00[ 86 : 107 ] = [ 0x50, 0x1e, 0x44, 0x11, # Apsel1
                                        0x52, 0x00, 0x88, 0x01, # Apsel2
                                        0x4e, 0x00, 0x22, 0x55, # Apsel3
                                        0x4c, 0x16, 0x11, 0xff, # Apsel4
                                        0x0f, 0x19, 0x44, 0x11, # Apsel5
                                        0xff ]

# Upper Page 00h
Osfp800g2lr4UpperPage00 = Osfp800gXdr8UpperPage00[ : ]
# Vendor PN
Osfp800g2lr4UpperPage00[ 30 : 34 ] = [ 0x32, 0x4c, 0x52, 0x34 ]
# Connector Type
Osfp800g2lr4UpperPage00[ 75 ] = 0x07

# Upper Page 01h
Osfp800g2lr4UpperPage01 = Osfp800gXdr8UpperPage01[ : ]
# Length Multiplier / Base Length SMF
Osfp800g2lr4UpperPage01[ 4 ] = 0x4a
# Nominal Wavelength
Osfp800g2lr4UpperPage01[ 10 : 12 ] = [ 0x65, 0xa4 ]
# Media Lane Assignment Options for Apps 1 - 5
Osfp800g2lr4UpperPage01[ 52 ] = 0x11
# Checksum
Osfp800g2lr4UpperPage01[ 127 ] = 0x30

# Upper Page 02h
Osfp800g2lr4UpperPage02 = Osfp800gXdr8UpperPage02[ : ]

##################################################
#
# OSFP Id EEPROM definitions
#
# 800GBASE-SR8
#   - CMIS 5.0 compliant
#   - supports 400kHz TWI access
#
##################################################
Osfp800gSr8LowerPage00 = Osfp800g2Fr4LowerPage00[ : ]
# Media type and Host/Media Apps
Osfp800gSr8LowerPage00[ 85 ] = 0x01
Osfp800gSr8LowerPage00[ 86 : 118 ] = [ 0x52, 0x12, 0x88, 0x01, # Apsel1
                                       0x50, 0x11, 0x44, 0x11, # Apsel2
                                       0x4e, 0x1b, 0x22, 0x55, # Apsel3
                                       0x4c, 0x0D, 0x11, 0xff, # Apsel4
                                       0x11, 0x10, 0x88, 0x01, # Apsel5
                                       0x0f, 0x0e, 0x44, 0x11, # Apsel6
                                       0x0d, 0x0c, 0x22, 0x55, # Apsel7
                                       0x0a, 0x07, 0x11, 0xff ] # Apsel8
Osfp800gSr8UpperPage00 = Osfp800g2Fr4UpperPage00[ : ]
# Vendor PN
Osfp800gSr8UpperPage00[ 29 : 33 ] = [ 0x53, 0x52, 0x38, 0x20 ]
# Media Interface Technology
Osfp800gSr8UpperPage00[ 84 ] = 0x00
Osfp800gSr8UpperPage01 = Osfp800g2Fr4UpperPage01[ : ]
# Base length SMF
Osfp800gSr8UpperPage01[ 4 : 8 ] = [ 0x00, 0x32, 0x32, 0x23 ]
# Nominal Wavelength
Osfp800gSr8UpperPage01[ 10 : 12 ] = [ 0x42, 0x68 ]
# Media Lane Assignment options for apps
Osfp800gSr8UpperPage01[ 48 : 56 ] = [ 0x01, 0x11, 0x55, 0xff,
                                      0x01, 0x11, 0x55, 0xff ]
Osfp800gSr8UpperPage01[ 95 ] = 0xff
# Checksum
Osfp800gSr8UpperPage01[ 127 ] = 0xfe
Osfp800gSr8UpperPage02 = Osfp800g2Fr4UpperPage02[ : ]

##################################################
# OSFP 800GBASE-2SR4
##################################################
Osfp800g2Sr4LowerPage00 = Osfp800g2Fr4LowerPage00[ : ]
# Media type and Host/Media Apps
Osfp800g2Sr4LowerPage00[ 85 ] = 0x01
Osfp800g2Sr4LowerPage00[ 86 : 103 ] = [ 0x50, 0x11, 0x44, 0x11, # Apsel1
                                        0x52, 0x12, 0x88, 0x01, # Apsel2
                                        0x4e, 0x1b, 0x22, 0x55, # Apsel3
                                        0x4c, 0x0d, 0x11, 0xff, # Apsel4
                                        0xff ]

Osfp800g2Sr4UpperPage00 = Osfp800g2Fr4UpperPage00[ : ]
# Vendor PN
Osfp800g2Sr4UpperPage00[ 31 ] = 0x53
# Connector Type
Osfp800g2Sr4UpperPage00[ 75 ] = 0x0c
# Media Interface Technology
Osfp800g2Sr4UpperPage00[ 84 ] = 0x00
Osfp800g2Sr4UpperPage01 = Osfp800g2Fr4UpperPage01[ : ]
# Base length SMF
Osfp800g2Sr4UpperPage01[ 4 : 8 ] = [ 0x00, 0x32, 0x32, 0x23 ]
# Nominal Wavelength
Osfp800g2Sr4UpperPage01[ 10 : 12 ] = [ 0x42, 0x68 ]
# Media Lane Assignment options for apps
Osfp800g2Sr4UpperPage01[ 52 ] = 0x00
# Checksum
Osfp800g2Sr4UpperPage01[ 127 ] = 0xfd
Osfp800g2Sr4UpperPage02 = Osfp800g2Fr4UpperPage02[ : ]

##################################################
# OSFP to 4 QSFP break out copper 400GBASE-CR8
##################################################
Osfp400gTo4QsfpLowerPage00 = [
   0x19, 0x40, 0x80, 0x07, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x1B, 0x01,
   0x22, 0x55, 0x45, 0x01, 0x22, 0x01, 0xFF, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
]

##################################################
# OSFP 800GBASE-2XDR4
##################################################
Osfp800g2Xdr4LowerPage00 = Osfp800g2Fr4LowerPage00[ : ]
Osfp800g2Xdr4LowerPage00[ 86 : 103 ] = [ 0x50, 0x1c, 0x44, 0x11, # Apsel1
                                         0x52, 0x00, 0x88, 0x01, # Apsel2
                                         0x4e, 0x00, 0x22, 0x55, # Apsel3
                                         0x4c, 0x15, 0x11, 0xff, # Apsel4
                                         0xff ]
Osfp800g2Xdr4LowerPage00[ 103 : 107 ] = [ 0x00 ] * 4

Osfp800g2Xdr4UpperPage00 = Osfp800g2Fr4UpperPage00[ : ]
Osfp800g2Xdr4UpperPage00[ 31 ] = 0x58 # 'x'
Osfp800g2Xdr4UpperPage00[ 32 ] = 0x44 # 'd'
Osfp800g2Xdr4UpperPage00[ 33 ] = 0x52 # 'r'
Osfp800g2Xdr4UpperPage00[ 34 ] = 0x34 # '4'
Osfp800g2Xdr4UpperPage00[ 75 ] = 0x0c # MPO 1x12 (Multifiber Parallel Optic)

Osfp800g2Xdr4UpperPage01 = Osfp800g2Fr4UpperPage01[ : ]
# Nominal wavelenth 1311nm
Osfp800g2Xdr4UpperPage01[ 10 ] = 0x66
Osfp800g2Xdr4UpperPage01[ 11 ] = 0x6c
Osfp800g2Xdr4UpperPage01[ 127 ] = 0xe1 # Checksum

Osfp800g2Xdr4UpperPage02 = Osfp800g2Fr4UpperPage02[ : ]

##################################################
# OSFP 800GBASE-2DR4
##################################################
Osfp800g2Dr4LowerPage00 = Osfp800g2Xdr4LowerPage00[ : ]
Osfp800g2Dr4LowerPage00[ 86 : 91 ] = [ 0x50, 0x1c, 0x44, 0x11, # Apsel1
                                         0xff ]
Osfp800g2Dr4LowerPage00[ 91 : 103 ] = [ 0x00 ] * 12

Osfp800g2Dr4UpperPage00 = Osfp800g2Xdr4UpperPage00[ : ]
Osfp800g2Dr4UpperPage00[ 31 ] = 0x44 # 'd'
Osfp800g2Dr4UpperPage00[ 32 ] = 0x52 # 'r'
Osfp800g2Dr4UpperPage00[ 33 ] = 0x34 # '4'
Osfp800g2Dr4UpperPage00[ 34 ] = 0x20 # ' '

Osfp800g2Dr4UpperPage01 = Osfp800g2Xdr4UpperPage01[ : ]
# Set reach to 500m
Osfp800g2Dr4UpperPage01[ 4 ] = 5
Osfp800g2Dr4UpperPage01[ 127 ] = 0xa4 # Checksum

##################################################
# OSFP LPO 800GBASE-2DR4
##################################################
OsfpLpo800g2Dr4LowerPage00 = [
   0x19, 0x51, 0x00, 0x06, 0x01, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x25, 0x4e,
   0x83, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xf0, 0x00, 0xff, 0x00, 0x00, 0x0e,
   0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x50, 0x1c,
   0x44, 0x11, 0x52, 0x00, 0x88, 0x01, 0x4e, 0x00,
   0x22, 0x55, 0x4c, 0x14, 0x11, 0xff, 0x4f, 0x1c,
   0x44, 0x11, 0x51, 0x00, 0x88, 0x01, 0x4d, 0x00,
   0x22, 0x55, 0x4b, 0x14, 0x11, 0xff, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02,
]
OsfpLpo800g2Dr4UpperPage00 = [
   0x19, 0x41, 0x72, 0x69, 0x73, 0x74, 0x61, 0x20,
   0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73,
   0x20, 0x00, 0x1c, 0x73, 0x4c, 0x50, 0x4f, 0x2d,
   0x38, 0x30, 0x30, 0x47, 0x2d, 0x32, 0x44, 0x52,
   0x34, 0x20, 0x20, 0x20, 0x35, 0x30, 0x58, 0x4b,
   0x54, 0x32, 0x34, 0x33, 0x30, 0x31, 0x37, 0x39,
   0x31, 0x35, 0x20, 0x20, 0x20, 0x20, 0x32, 0x34,
   0x30, 0x37, 0x32, 0x36, 0x20, 0x20, 0x20, 0x20,
   0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
   0x80, 0x22, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x0e,
   0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x0e, 0x04, 0x00, 0x00, 0xff, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0xdf, 0x28, 0x8d, 0xa8,
]
OsfpLpo800g2Dr4UpperPage01 = [
   0x0e, 0x03, 0x01, 0x00, 0x05, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x66, 0x6c, 0x05, 0x14, 0x04, 0xdf,
   0x77, 0x60, 0x46, 0x00, 0x00, 0x00, 0x9d, 0x18,
   0x00, 0xf5, 0x10, 0x2a, 0x06, 0x03, 0x02, 0x03,
   0x17, 0x04, 0x14, 0x77, 0xff, 0x1f, 0x80, 0x57,
   0x57, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x11, 0x01, 0x55, 0xff, 0x11, 0x01, 0x55, 0xff,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x4c, 0xfe, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xea,
]
OsfpLpo800g2Dr4UpperPage02 = [
   0x4e, 0x00, 0xf8, 0x00, 0x49, 0x00, 0xfd, 0x00,
   0x8d, 0xcc, 0x74, 0x04, 0x87, 0x5a, 0x7a, 0x76,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x9b, 0x83, 0x0c, 0xa4, 0x62, 0x1f, 0x14, 0x09,
   0xb9, 0x8c, 0x22, 0x2e, 0xaa, 0xe6, 0x27, 0x10,
   0x8a, 0x99, 0x05, 0xa5, 0x7b, 0x87, 0x06, 0x56,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21,
]
OsfpLpo800g2Dr4UpperPage10 = [
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x11, 0x11, 0x11, 0x11, 0x19, 0x19, 0x19,
   0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x33, 0x33, 0x33, 0x33, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0xff, 0x33, 0x33, 0x33, 0x33, 0x4e, 0x4e, 0x4e,
   0x4e, 0x4e, 0x4e, 0x4e, 0x4e, 0x00, 0x00, 0x00,
]
OsfpLpo800g2Dr4UpperPage11 = [
   0x44, 0x44, 0x44, 0x44, 0x00, 0xff, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0xff, 0x00,
   0xff, 0x00, 0x39, 0xec, 0x3a, 0xcb, 0x31, 0x37,
   0x30, 0xca, 0x2f, 0x96, 0x2e, 0xcc, 0x38, 0x07,
   0x37, 0xdd, 0x3e, 0x81, 0x3e, 0x8b, 0x3d, 0xab,
   0x3d, 0xb5, 0x3e, 0x44, 0x3e, 0x3a, 0x3d, 0xf2,
   0x3d, 0xe8, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01,
   0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01,
   0x00, 0x01, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
   0x11, 0x11, 0x19, 0x19, 0x19, 0x19, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x33,
   0x33, 0x33, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18,
   0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18,
]
OsfpLpo800g2Dr4UpperPageC1 = [
   0x07, 0x7c, 0x0f, 0x00, 0x00, 0x00, 0xff, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x91,
]
OsfpLpo800g2Dr4UpperPageC2 = [
   0xff, 0x33, 0x33, 0x33, 0x33, 0x4e, 0x4e, 0x4e,
   0x4e, 0x4e, 0x4e, 0x4e, 0x4e, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
]

##################################################
# OSFP 800GBASE-2PLR4
##################################################
Osfp800g2Plr4LowerPage00 = Osfp800g2Xdr4LowerPage00[ : ]
Osfp800g2Plr4LowerPage00[ 86 : 103 ] = [ 0x50, 0x00, 0x44, 0x11, # Apsel1
                                         0x52, 0x00, 0x88, 0x01, # Apsel2
                                         0x4e, 0x00, 0x22, 0x55, # Apsel3
                                         0x4c, 0x16, 0x11, 0xff, # Apsel4
                                         0xff ]

Osfp800g2Plr4UpperPage00 = Osfp800g2Xdr4UpperPage00[ : ]
Osfp800g2Plr4UpperPage00[ 31 ] = 0x50 # 'p'
Osfp800g2Plr4UpperPage00[ 32 ] = 0x4c # 'l'

Osfp800g2Plr4UpperPage01 = Osfp800g2Xdr4UpperPage01[ : ]
Osfp800g2Plr4UpperPage01[ 4 ] = 0x4a # Length multiplier
Osfp800g2Plr4UpperPage01[ 127 ] = 0xe9 # Checksum

Osfp800g2Plr4UpperPage02 = Osfp800g2Xdr4UpperPage02[ : ]

##################################################
# OSFP LPO 800GBASE-2XDR4
##################################################
OsfpLpo800g2Xdr4UpperPage00 = Osfp800g2Xdr4UpperPage00[ : ]
OsfpLpo800g2Xdr4UpperPage00[ 20 : 36 ] = "LPO-800G-2XDR4  ".encode( "ascii" )

##################################################
# CMIS 5.0 Xcvr Page 13
# Template for all Cmis Xcvrs with PRBS/Diagnostic
# capabilities as of right now
##################################################
CmisUpperPage13Bank0 = [ 0x00 ] * 128

##################################################
# OSFP 400GBASE-SRBD Rev. 40
##################################################

Osfp400gSrbdLowerPage00 = Osfp400gSr8LowerPage00[ : ]
Osfp400gSrbdLowerPage00[ 86 : 90 ] = [ 0x11, 0x1a, 0x88, 0x01 ]  # Apsel1
Osfp400gSrbdLowerPage00[ 90 : 94 ] = [ 0x0d, 0x0b, 0x22, 0x55 ]  # Apsel2
Osfp400gSrbdLowerPage00[ 94 : 99 ] = [ 0x0d, 0x00, 0x22, 0x55, 0xff ]  # Apsel 3

Osfp400gSrbdUpperPage00 = Osfp400gSr8UpperPage00[ : ]
Osfp400gSrbdUpperPage00[ 29 : 33 ] = [ 0x53, 0x52, 0x42, 0x44 ] # "SRBD"
Osfp400gSrbdUpperPage00[ 36 : 38 ] = [ 0x34, 0x30 ] # Revision 40
Osfp400gSrbdUpperPage00[ 75 ] = 0x0c # MPO 1x12 (Multifiber Parallel Optic)

Osfp400gSrbdUpperPage01 = [
   0x00, 0x00, 0x00, 0x00, 0x00, 0x4b, 0x32, 0x23,
   0x00, 0x00, 0x42, 0x68, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4b,
]
