# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Upper page 0
SRQSFP = [
   0x0D, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 'vn', 'vn', 'vn', 'vn',
   'vn', 'vn', 'vn', 'vn', 'vn', 'vn', 'vn', 'vn',
   'vn', 'vn', 'vn', 'vn', 0x00, 0x00, 0x1C, 0x73,
   0x53, 0x46, 0x50, 0x2D, 0x34, 0x30, 0x47, 0x2D,
   0x53, 0x52, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
   0x30, 0x31, 0x42, 0x68, 0x00, 0x00, 0x00, 'cc',
   0x00, 0x00, 0x00, 0x00, 0x58, 'sn', 'sn', 'sn',
   'sn', 'sn', 'sn', 'sn', 'sn', 'sn', 'sn', 'sn',
   0x20, 0x20, 0x20, 0x20, 'dc', 'dc', 'dc', 'dc',
   'dc', 'dc', 'dc', 'dc', 0x00, 0x00, 0x00, 'cc',
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xf8,
   0x02, 0xce, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
]

# SRQSFP1002 has both Mbase and HBase
SRQSFP1002 = SRQSFP[ : ]
SRQSFP1002[ 118 : 124 ] = [ 0x02, 0xf8, 0x02, 0xce, 0x02, 0xe4 ]

# SRQSFP1003 has neither Mbase nor HBase
SRQSFP1003 = SRQSFP[ : ]
SRQSFP1003[ 118 : 124 ] = [ 0x02, 0xf8, 0x00, 0x00, 0x00, 0x00 ]

# SRQSFP1004 supports Tx power measurement
SRQSFP1004 = SRQSFP[ : ]
SRQSFP1004[ 92 ] = 0x4 # Enable Tx power measurement (page 0 byte 220)

# SRQSFPNOSOLREGBASE1003 has neither SolRegBase nor Mbase nor HBase
SRQSFPNOSOLREGBASE1003 = SRQSFP[ : ]
SRQSFPNOSOLREGBASE1003[ 118 : 124 ] = [ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 ]

LR4QSFP = SRQSFP[ : ]
LR4QSFP[ 3 ] = 0x02 # Set compliance10And40G
LR4QSFP[ 2 ] = 0x07 # Set connector type to LC
LR4QSFP[ 14 ] = 0x0A # Set lengthSmf = 10km
LR4QSFP[ 15 ] = 0x0 # Set OM3 length
LR4QSFP[ 16 ] = 0x0 # Set OM2 length
LR4QSFP[ 58 ] = 0x66 # set wavelength to 1310
LR4QSFP[ 59 ] = 0x58

# LR4QSFP1002 supports Tx power measurement
LR4QSFP1002 = LR4QSFP[ : ]
LR4QSFP1002[ 92 ] = 0x4 # Enable Tx power measurement (page 0 byte 220)

LRL4QSFP = LR4QSFP[ : ]
LRL4QSFP[ 14 ] = 0x01 # Set lengthSmf = 1km

PLR4QSFP = LR4QSFP[ : ]
PLR4QSFP[ 2 ] = 0x0C # Set connector as MPO

PLRL4QSFP = PLR4QSFP[ : ]
PLRL4QSFP[ 14 ] = 0x01 # Set lengthSmf

PLR4QSFP3PTY = PLR4QSFP[ : ]
PLR4QSFP3PTY[ 3 ] = 0x20 # Set compliance10And40G

PSM4QSFP = PLRL4QSFP[ : ]
PSM4QSFP[ 3 ] = 0x80    # Bit7 = 1 for PSM4

XSR4QSFP = SRQSFP1004[ : ]
XSR4QSFP[ 15 ] = 0x96 # Set lengthOM3

SR4DQSFP = SRQSFP[ : ]
SR4DQSFP[ 2 ] = 0x07 # Set connector type to LC
SR4DQSFP[ 3 ] = 0x04 # Set compliance10And40G
SR4DQSFP[ 15 ] = 0x78 # Set OM3 length

SRBDQSFP = SRQSFP[ : ]
SRBDQSFP[ 1 ] = 0x0C # Set CDR in TX and RX path
SRBDQSFP[ 3 ] = 0x00 # Set compliance10And40G, no code specified
SRBDQSFP[ 12 ] = 0xCE # Set BitRate

SRBDQSFP3RDPTY = SRBDQSFP[ : ]
SRBDQSFP3RDPTY[ 1 ] = 0xDC # Set other bits apart from CDR in TX and RX path

CR4QSFP = SRQSFP[ : ]
CR4QSFP[ 2 ] = 0x23 # No separate connector
CR4QSFP[ 3 ] = 0x08 # Set compliance10And40G

# Alternate QSFP passive copper identifier
CR4QSFP3RDPTY = CR4QSFP[ : ]
CR4QSFP3RDPTY[ 3 ] = 0x00 # Unset compliance10And40G
CR4QSFP3RDPTY[ 11 ] = 0x67 # Bit-rate 10.3G
CR4QSFP3RDPTY[ 19 ] = 0xA0 # Cu cable, unequalized

AR4QSFP = CR4QSFP[ : ]
AR4QSFP[ 3 ] = 0x01 # Set compliance10And40G

UNIVQSFP = LR4QSFP[ : ]
UNIVQSFP[ 14 ] = 0x01 # Set lengthSmf = 1km
UNIVQSFP[ 15 ] = 0x4B # Set OM3 length

ER4QSFP = LR4QSFP[ : ]
ER4QSFP[ 3 ] = 0x80    # Bit7 = Extended type
ER4QSFP[ 64 ] = 0x10    # Extended type QSFP+ ER4

UNKNOWNQSFP = SRQSFP[ : ]
UNKNOWNQSFP[ 3 ] = 0x00    # Set compliance10And40G

FAULTYQSFP = [ 0xff ] + SRQSFP[ 1 : ]

# 100GBASE-SR4 QSFP is the same as 40G SR4 with minor changes.
SR4QSFP100G = SRQSFP[ : ]
SR4QSFP100G[ 0 ] = 0x11
SR4QSFP100G[ 3 ] = 0x80    # Set the compliance to point to extended table.
SR4QSFP100G[ 11 ] = 0x07   # Encoding
SR4QSFP100G[ 40 : 53 ] = [ 0x51, 0x53, 0x46, 0x50, 0x2d, 0x31, 0x30,  # Vendor part
                           0x30, 0x47, 0x2d, 0x53, 0x52, 0x34 ]       # number
SR4QSFP100G[ 64 ] = 2
SR4QSFP100G[ 65 ] = 7      # Set optical tuning supported

# 100GBASE-SR4-E
SR4EQSFP100G = SR4QSFP100G[ : ]
SR4EQSFP100G[ 11 ] = 0x05                # Encoding
SR4EQSFP100G[ 53 : 55 ] = [ 0x2d, 0x45 ] # Adds "-E" to PN

# 100GBASE-XSR4
XSR4QSFP100G = SR4QSFP100G[ : ]
XSR4QSFP100G[ 15 ] = 170 // 2 # Length OM3
XSR4QSFP100G[ 18 ] = 300 // 2 # Length OM4

UNKNOWNQSFP100G = UNKNOWNQSFP[ : ]
UNKNOWNQSFP100G[ 0 ] = 0x11
# Set bit 0, byte 195, page 00 to 1, which indicates that
# page20h and 21h are implemented.
UNKNOWNQSFP100G[ 67 ] = 0x01

# UNKNOWN QSFP100 optical modules with device technology
# shouldn't be identified as copper.
UNKNOWNQSFP100GOPTICS = UNKNOWNQSFP100G[ : ]
UNKNOWNQSFP100GOPTICS[ 19 ] = 0x60 # not passive copper

# 3rd party modules that identifies both 40G and 100G SR4.
SR4QSFP100G40G3RDPTY = SR4QSFP100G[ : ]
SR4QSFP100G40G3RDPTY[ 3 ] = 0x84 # Set compliance10And40G.

LR4QSFP100G = SR4QSFP100G[ : ]
LR4QSFP100G[ 64 ] = 3
LR4QSFP100G[ 2 ] = 0x07 # Set connector type to LC
LR4QSFP100G[ 11 ] = 0x05 # Set encoding
LR4QSFP100G[ 14 ] = 0x0A # Set lengthSmf = 10km
LR4QSFP100G[ 15 ] = 0x0 # Set OM3 length
LR4QSFP100G[ 16 ] = 0x0 # Set OM2 length
LR4QSFP100G[ 58 ] = 0x66 # set wavelength to 1310
LR4QSFP100G[ 59 ] = 0x58
# We assume initComplete ready when timeout. BUG161309
LR4QSFP100G[ 93 ] = 0x10  # Set initialization complete flag implemented

LRL4QSFP100G = LR4QSFP100G[ : ]
LRL4QSFP100G[ 14 ] = 0x02 # Set lengthSmf = 2km

# 3rd party modules that identifies both 40G and 100G LR4.
LR4QSFP100G40G3RDPTY = LR4QSFP100G[ : ]
LR4QSFP100G40G3RDPTY[ 3 ] = 0x82   # Set compliance10And40G.
LR4QSFP100G40G3RDPTY[ 92 ] = 0x0C  # Set transmitter power measurement

# 100GBASE-DR
DRQSFP100G = LR4QSFP100G[ : ]
DRQSFP100G[ 64 ] = 0x25

# 100GBASE-FR (no FEC)
FRQSFP100G = LR4QSFP100G[ : ]
FRQSFP100G[ 64 ] = 0x26

# 100GBASE-FR (no FEC) that supports enhanced DOM.
FRQSFP100GENDOM = FRQSFP100G[ : ]
# Set bit 0, byte 195, page 00 to 1, which indicates that
# page20h and 21h are implemented.
FRQSFP100GENDOM[ 67 ] = 0x01

# 100GBASE-LR (no FEC)
LRQSFP100G = LR4QSFP100G[ : ]
LRQSFP100G[ 64 ] = 0X27

# 100GBASE-FR (FEC)
FRFECQSFP100G = LR4QSFP100G[ : ]
FRFECQSFP100G[ 64 ] = 0x2A

# 100GBASE-LR (FEC)
LRFECQSFP100G = LR4QSFP100G[ : ]
LRFECQSFP100G[ 64 ] = 0x2B

# 100GBASE-ER (no FEC)
ERQSFP100G = LR4QSFP100G[ : ]
ERQSFP100G[ 64 ] = 0x2D

# 100GBASE-ER (FEC)
ERFECQSFP100G = LR4QSFP100G[ : ]
ERFECQSFP100G[ 64 ] = 0X34

ER4QSFP100G = LR4QSFP100G[ : ]
ER4QSFP100G[ 64 ] = 4
ER4QSFP100G[ 14 ] = 0x28 # Set lengthSmf = 10km

AR4QSFP100G = SR4QSFP100G[ : ]
AR4QSFP100G[ 2 ] = 0x23
AR4QSFP100G[ 64 ] = 0x01

AR4NQSFP100G = SR4QSFP100G[ : ]
AR4NQSFP100G[ 2 ] = 0x23
AR4NQSFP100G[ 64 ] = 0x18

# 3rd party modules that identifies both 40G and 100G AR4.
AR4QSFP100G40G3RDPTY = AR4QSFP100G[ : ]
AR4QSFP100G40G3RDPTY[ 3 ] = 0x81   # Set compliance10And40G.

AR4NQSFP100G40G3RDPTY = AR4NQSFP100G[ : ]
AR4NQSFP100G40G3RDPTY[ 3 ] = 0x81   # Set compliance10And40G.

CR4QSFP100G = SR4QSFP100G[ : ]
CR4QSFP100G[ 0 ] = 0x11 # QSFP100
CR4QSFP100G[ 2 ] = 0x23 # No separate connector
CR4QSFP100G[ 64 ] = 0x0B # Extended type 100GBASE-CR4 or 25GBASE-CR CA-L

CR2LQSFP50G = CR4QSFP100G[ : ] # 50GBASE-CR2 CA-L

CR4SQSFP100G = CR4QSFP100G[ : ]
CR4SQSFP100G[ 64 ] = 0x0C # 25GBASE-CR CA-S

CR2SQSFP50G = CR4SQSFP100G[ : ] # 50GBASE-CR2 CA-S

CR4NQSFP100G = CR4QSFP100G[ : ]
CR4NQSFP100G[ 64 ] = 0x0D # 25GBASE-CR CA-N

CRA4QSFP100G = CR4QSFP100G[ : ]
CRA4QSFP100G[ 64 ] = 0x19 # 100G ACC

CR2NQSFP50G = CR4NQSFP100G[ : ] # 50GBASE-CR2 CA-N

# Alternate 100G QSFP passive copper identifier
CR4QSFP100G3RDPTY = CR4QSFP100G[ : ]
CR4QSFP100G3RDPTY[ 3 ] = 0x00 # Unset compliance10And40G
CR4QSFP100G3RDPTY[ 19 ] = 0xA0 # Cu cable, unequalized
CR4QSFP100G3RDPTY[ 64 ] = 0x00 # Unset extended type

# 3rd party modules that identifies both 40G and 100G CR4.
CR4QSFP100G40G3RDPTY = CR4QSFP100G[ : ]
CR4QSFP100G40G3RDPTY[ 3 ] = 0x88 # Set compliance10And40G.

PSM4QSFP100G = SR4QSFP100G[ : ]
PSM4QSFP100G[ 2 ] = 0x0C # Set connector type to MPO 1x12
PSM4QSFP100G[ 64 ] = 0x07 # Extended type for 100GBASE-PSM4

PLRL4QSFP100G = PSM4QSFP100G[ : ]
PLRL4QSFP100G[ 14 ] = 0x02 # length SMF = 2km
PLRL4QSFP100G[ 51 : 55 ] = [ 0x4C, 0x52, 0x4C, 0x34 ] # vendor PN

PLR4QSFP100G = PLRL4QSFP100G[ : ]
PLR4QSFP100G[ 14 ] = 0x0A # length SMF = 10km
PLR4QSFP100G[ 51 : 53 ] = [ 0x34, 0x20 ] # vendor PN

CLR4QSFP100G = SR4QSFP100G[ : ]
CLR4QSFP100G[ 2 ] = 0x07 # Set connector type to LC
CLR4QSFP100G[ 64 ] = 0x17 # Extended type for 100GBASE-CLR4

# 3rd party modules that identifies both 40G and 100G CR4.
CR4QSFP100G40G3RDPTY = CR4QSFP100G[ : ]
CR4QSFP100G40G3RDPTY[ 3 ] = 0x88 # Set compliance10And40G.

CWDM4QSFP100G = SR4QSFP100G[ : ]
CWDM4QSFP100G[ 64 ] = 0x06 # Extended type for 100GBASE-CWDM4

# 2-wavelength DWDM module
DWDM2QSFP100G = SR4QSFP100G[ : ]
DWDM2QSFP100G[ 2 ] = 0x07 # Set connector type to LC
DWDM2QSFP100G[ 14 ] = 0x28 # Set lengthSmf = 40km
DWDM2QSFP100G[ 58 ] = 0x79 # Set wavelength to 1559.8nm
DWDM2QSFP100G[ 59 ] = 0xDC # Set wavelength to 1559.8nm
DWDM2QSFP100G[ 64 ] = 0x1A # Extended type for 100GE-DWDM2
# Set bit 0, byte 195, page 00 to 1, which indicates that
# page20h and 21h are implemented.
DWDM2QSFP100G[ 67 ] = 0x01

SWDM4QSFP100G = SR4QSFP100G[ : ]
SWDM4QSFP100G[ 2 ] = 0x07 # Set connector type to LC
SWDM4QSFP100G[ 64 ] = 0x20 # Extended type for 100GBASE-SWDM4

SRBDQSFP100G = SR4QSFP100G[ : ]
SRBDQSFP100G[ 2 ] = 0x07 # Set connector type to LC
SRBDQSFP100G[ 64 ] = 0x21 # Extended type for 100GBASE-SRBD

ERL4QSFP100G = LR4QSFP100G[ : ]
ERL4QSFP100G[ 64 ] = 4
ERL4QSFP100G[ 14 ] = 0x1E # Set lengthSmf = 30km
ERL4QSFP100G[ 2 ] = 0x07 # Set connector type to LC

XCWDM4QSFP100G = CWDM4QSFP100G[ : ]
XCWDM4QSFP100G[ 14 ] = 0x0A # Set lengthSmf = 10km

ZR4QSFP100G = SR4QSFP100G[ : ]
ZR4QSFP100G[ 64 ] = 0x00 # Extended type unspecified
ZR4QSFP100G[ 11 ] = 0x05 # Encoding 64b/66b
ZR4QSFP100G[ 113 ] = 0x01 # Arista extended type 100GBASE-ZR4

Qsfp400g2QqsfpSide = [
   0x11, 0x00, 0x23, 0x80, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x08, 0xff, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x02, 0xa0, 0x41, 0x72, 0x69, 0x73,
   0x74, 0x61, 0x20, 0x4e, 0x65, 0x74, 0x77, 0x6f,
   0x72, 0x6b, 0x73, 0x20, 0x00, 0x00, 0x1c, 0x73,
   0x43, 0x41, 0x42, 0x2d, 0x44, 0x2d, 0x32, 0x51,
   0x2d, 0x34, 0x30, 0x30, 0x2d, 0x32, 0x2e, 0x35,
   0x32, 0x30, 0x05, 0x07, 0x09, 0x0f, 0x55, 0x32,
   0x40, 0x00, 0x00, 0x00, 0x41, 0x50, 0x46, 0x31,
   0x39, 0x32, 0x35, 0x30, 0x30, 0x35, 0x30, 0x52,
   0x41, 0x57, 0x20, 0x20, 0x31, 0x39, 0x30, 0x38,
   0x31, 0x34, 0x20, 0x20, 0x00, 0x00, 0xd4, 0x22,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x5e, 0x8f, 0x34, 0x08,
]

Qsfp400g2QqsfpSide40G = Qsfp400g2QqsfpSide[ : ]
Qsfp400g2QqsfpSide40G[ 3 ] = 0x88 # Set compliance code to 40GBASE-CR4 + extended

Qsfp400g2QqsfpSideDepop = Qsfp400g2QqsfpSide[ : ]

##################################################
# QSFP56-8636 Copper Cable Template
##################################################
Qsfp56Sff8636Cu200GUpperPage0 = [
   0x11, 0x00, 0x23, 0x88, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x01, 0xa0, 'vn', 'vn', 'vn', 'vn',
   'vn', 'vn', 'vn', 'vn', 'vn', 'vn', 'vn', 'vn',
   'vn', 'vn', 'vn', 'vn', 0x00, 0x00, 0x40, 0x20,
   0x34, 0x2d, 0x32, 0x33, 0x33, 0x33, 0x38, 0x34,
   0x32, 0x2d, 0x32, 0x20, 0x20, 0x20, 0x20, 0x20,
   0x42, 0x20, 0x03, 0x04, 0x06, 0x08, 0x00, 'cc',
   0x40, 0x00, 0x00, 0x00, 0x58, 'M', 'M', 'Y',
   'Y', 'W', 'W', 'Z', 'Z', 'Z', 'Z', 'Z',
   0x20, 0x20, 0x20, 0x20, 0x32, 0x30, 0x30, 0x32,
   'y', 'y', 'm', 'm', 'd', 'd', 'lc', 'lc',
   0x32, 0x30, 0x30, 'cc', 0x32, 0x39, 0x35, 0x35,
   0x34, 0x37, 0x30, 0x20, 0x20, 0x20, 0x20, 0x20,
   0x20, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
]

##################################################
# QSFP56-8636 SR4 Cable Template
##################################################
Qsfp56Sff8636Sr4UpperPage0 = Qsfp56Sff8636Cu200GUpperPage0[ : ]
Qsfp56Sff8636Sr4UpperPage0[ 3 ] = 0x80
Qsfp56Sff8636Sr4UpperPage0[ 58 ] = 0x42 # set wavelength to 850
Qsfp56Sff8636Sr4UpperPage0[ 59 ] = 0x68
Qsfp56Sff8636Sr4UpperPage0[ 64 ] = 0x41

##################################################
# QSFP56-8636 FR4 Cable Template
##################################################
Qsfp56Sff8636Fr4UpperPage0 = Qsfp56Sff8636Cu200GUpperPage0[ : ]
Qsfp56Sff8636Fr4UpperPage0[ 3 ] = 0x80
Qsfp56Sff8636Fr4UpperPage0[ 58 ] = 0x66 # set wavelength to 1310
Qsfp56Sff8636Fr4UpperPage0[ 59 ] = 0x58
Qsfp56Sff8636Fr4UpperPage0[ 64 ] = 0x43

##################################################
# QSFP56-8636 AOC Cable Template
##################################################
Qsfp56Sff8636Ar4UpperPage0 = Qsfp56Sff8636Cu200GUpperPage0[ : ]
Qsfp56Sff8636Ar4UpperPage0[ 3 ] = 0x80
Qsfp56Sff8636Ar4UpperPage0[ 58 ] = 0x42 # set wavelength to 850
Qsfp56Sff8636Ar4UpperPage0[ 59 ] = 0x68
Qsfp56Sff8636Ar4UpperPage0[ 64 ] = 0x31

##################################################
# QSFP-LS Templates
##################################################
QsfpLsLowerPage0 = [
   0x11, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0xA0,
   0x05, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
]

QsfpLsUpperPage0 = [
   0x11, 0xC0, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0x00,
   0x00, 0x00, 0x00, 0x00, 'vn', 'vn', 'vn', 'vn',
   'vn', 'vn', 'vn', 'vn', 'vn', 'vn', 'vn', 'vn',
   'vn', 'vn', 'vn', 'vn', 0x00, 0x00, 0x1C, 0x73,
   0x51, 0x53, 0x46, 0x50, 0x2D, 0x41, 0x4D, 0x50,
   0x2D, 0x5A, 0x52, 0x20, 0x20, 0x20, 0x20, 0x20,
   0x32, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 'cc',
   0xC2, 0x00, 0x00, 0x00, 0x58, 'sn', 'sn', 'sn',
   'sn', 'sn', 'sn', 'sn', 'sn', 'sn', 'sn', 'sn',
   0x20, 0x20, 0x20, 0x20, 'dc', 'dc', 'dc', 'dc',
   'dc', 'dc', 'dc', 'dc', 0x3C, 0x00, 0x00, 'cc',
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
]

QsfpLsUpperPage2 = [
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x93, 0x76,
   0x00, 0x04, 0x75, 0x30, 0x00, 0x08, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF4, 0x24,
   0x01, 0x37, 0xD0, 0x4A, 0x04, 0xE2, 0x00, 0x00,
]

QsfpLsUpperPage3 = [
   0x46, 0x00, 0xFB, 0x00, 0x41, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x87, 0x5A, 0x7A, 0x76, 0x84, 0xC6, 0x7D, 0x0A,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x48, 0x00, 0x00, 0x00, 0x46, 0x00, 0x05, 0x00,
   0x48, 0x00, 0x00, 0x00, 0x46, 0x00, 0x05, 0x00,
   0x00, 0xEF, 0x00, 0x05, 0x00, 0xD5, 0x00, 0x08,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0xFA, 0x6C, 0x01, 0x38, 0xF4, 0xB8, 0x04, 0xE2,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
]

##################################################
# QSFP-100G-SR1.2 Templates
##################################################

Qsfp100gSr1_2Lower00h = [
   0x11, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
]

Qsfp100gSr1_2Upper00h = [
   0x11, 0x0C, 0x07, 0x80, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x05, 0xFF, 0x00, 0x00, 0x23,
   0x00, 0x00, 0x32, 0x00, 0x41, 0x72, 0x69, 0x73,
   0x74, 0x61, 0x20, 0x4E, 0x65, 0x74, 0x77, 0x6F,
   0x72, 0x6B, 0x73, 0x20, 0x00, 0x00, 0x1C, 0x73,
   0x51, 0x53, 0x46, 0x50, 0x2D, 0x31, 0x30, 0x30,
   0x47, 0x2D, 0x53, 0x52, 0x31, 0x2E, 0x32, 0x20,
   0x32, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x21, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x67, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
]

# Spoofed DOM data for QSFP-LS. Values correlate to:
#  * Temperature == 30.0C
#  * Voltage == 3.3V
#  * Rx1 (booster) == -20.71dB (0x0055), Rx2 (pre-amp) == -19.24dB (0x0077)
#  * Tx bias == 0.00mA (not reported by QSFP-LS)
#  * Tx1 (booster) == 3.39dB (0x5555), Tx2 (pre-amp) == 4.85dB (0x7777)
# Entire monitoring field is 36 bytes big
qsfpLsDomByteArray = bytearray( 36 )
qsfpLsDomByteArray[ 0 : 2 ] = b'\x1e\x00'
qsfpLsDomByteArray[ 4 : 6 ] = b'\x80\xe8'
qsfpLsDomByteArray[ 12 : 14 ] = b'\x00\x55'
qsfpLsDomByteArray[ 14 : 16 ] = b'\x00\x77'
qsfpLsDomByteArray[ 28 : 30 ] = b'\x55\x55'
qsfpLsDomByteArray[ 30 : 32 ] = b'\x77\x77'
qsfpLsDomBytes = bytes( qsfpLsDomByteArray )

##################################################
# QSFP-400G-CR4 Templates
##################################################
Qsfp400GCr4Lower00 = [ 0x11, 0x08, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00,
                       0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                       0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                       0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                       0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                       0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                       0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                       0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                       0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                       0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                       0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                       0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                       0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                       0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x08, 0x00,
                       0x00, 0x10, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00,
                       0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                     ]
Qsfp400GCr4Upper00 = [ 0x11, 0x00, 0x23, 0x88, 0x00, 0x00, 0x00, 0x00,
                       0x00, 0x00, 0x00, 0x08, 0xff, 0x00, 0x00, 0x00,
                       0x00, 0x12, 0x03, 0xa0, 0x41, 0x6d, 0x70, 0x68,
                       0x65, 0x6e, 0x6f, 0x6c, 0x20, 0x20, 0x20, 0x20,
                       0x20, 0x20, 0x20, 0x20, 0x3f, 0x78, 0xa7, 0x14,
                       0x4e, 0x4a, 0x41, 0x41, 0x4b, 0x36, 0x2d, 0x30,
                       0x30, 0x30, 0x38, 0x20, 0x20, 0x20, 0x20, 0x20,
                       0x45, 0x20, 0x05, 0x06, 0x07, 0x09, 0x55, 0x23,
                       0x3f, 0x00, 0x00, 0x00, 0x41, 0x50, 0x46, 0x32,
                       0x34, 0x30, 0x39, 0x30, 0x30, 0x38, 0x33, 0x50,
                       0x30, 0x41, 0x20, 0x20, 0x32, 0x34, 0x30, 0x33,
                       0x32, 0x35, 0x20, 0x20, 0x00, 0x00, 0xd5, 0xf6,
                       0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                       0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                       0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                       0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                     ]
Qsfp400gCr4NoCompCodeUpper00 = [ 0x11, 0x00, 0x23, 0x00, 0x00, 0x00, 0x00, 0x00,
                                 0x00, 0x00, 0x00, 0x08, 0xff, 0x00, 0x00, 0x00,
                                 0x00, 0x12, 0x03, 0xa0, 0x41, 0x6d, 0x70, 0x68,
                                 0x65, 0x6e, 0x6f, 0x6c, 0x20, 0x20, 0x20, 0x20,
                                 0x20, 0x20, 0x20, 0x20, 0x3f, 0x78, 0xa7, 0x14,
                                 0x4e, 0x4a, 0x41, 0x41, 0x4b, 0x36, 0x2d, 0x30,
                                 0x30, 0x30, 0x38, 0x20, 0x20, 0x20, 0x20, 0x20,
                                 0x45, 0x20, 0x05, 0x06, 0x07, 0x09, 0x55, 0x23,
                                 0x00, 0x00, 0x00, 0x00, 0x41, 0x50, 0x46, 0x32,
                                 0x34, 0x30, 0x39, 0x30, 0x30, 0x38, 0x33, 0x50,
                                 0x30, 0x41, 0x20, 0x20, 0x32, 0x34, 0x30, 0x33,
                                 0x32, 0x35, 0x20, 0x20, 0x00, 0x00, 0xd5, 0xf6,
                                 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                                 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                                 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                                 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                                 ]
