# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

##################################################
# QSFP56 200GBASE-FR4
# Finisar
##################################################
QsfpCmis200gFr4LowerPage00 = [
   0x1e, 0x40, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x7d,
   0x80, 0xac, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xca,
   0xa7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x0f, 0x18,
   0x44, 0x01, 0x0b, 0x10, 0x44, 0x01, 0xff, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
]

QsfpCmis200gFr4UpperPage00 = [
   0x1e, 0x46, 0x49, 0x4e, 0x49, 0x53, 0x41, 0x52,
   0x20, 0x43, 0x4f, 0x52, 0x50, 0x2e, 0x20, 0x20,
   0x20, 0x00, 0x90, 0x65, 0x46, 0x54, 0x43, 0x43,
   0x31, 0x31, 0x31, 0x32, 0x45, 0x31, 0x50, 0x4c,
   0x4c, 0x2d, 0x46, 0x42, 0x37, 0x37, 0x58, 0x31,
   0x50, 0x41, 0x48, 0x54, 0x44, 0x20, 0x20, 0x20,
   0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x31, 0x39,
   0x30, 0x38, 0x31, 0x34, 0x00, 0x00, 0x20, 0x20,
   0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
   0x40, 0x1a, 0xde, 0x07, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
]

QsfpCmis200gFr4UpperPage01 = [
   0x00, 0x00, 0x0a, 0x01, 0x1e, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x65, 0xa4, 0x1b, 0xee, 0x20, 0x04,
   0x57, 0x00, 0x41, 0x0f, 0x00, 0x00, 0x9d, 0x18,
   0x00, 0x20, 0x00, 0x2f, 0x03, 0x07, 0x06, 0x03,
   0x07, 0x09, 0x21, 0x00, 0x0f, 0x9f, 0x80, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e,
   #0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xbf,
]

QsfpCmis200gFr4UpperPage02 = [
   0x46, 0x00, 0x0a, 0x00, 0x46, 0x00, 0x0a, 0x00,
   0x8b, 0x42, 0x76, 0x8e, 0x8b, 0x42, 0x76, 0x8e,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0xb6, 0xb6, 0x09, 0x5f, 0xb6, 0xb6, 0x09, 0x5f,
   0x92, 0x7c, 0x1d, 0x4c, 0x92, 0x7c, 0x1d, 0x4c,
   0xb6, 0xb6, 0x00, 0x01, 0xb6, 0xb6, 0x00, 0x01,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb2,
]

QsfpCmis200gFr4UpperPage10 = [
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x11, 0x11, 0x11, 0x11, 0x18, 0x18, 0x18,
   0x18, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10,
   0x18, 0x18, 0x18, 0x18, 0xff, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
]

QsfpCmis200gFr4UpperPage11 = [
   0x44, 0x44, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x52, 0xf6, 0x69, 0xae, 0x59, 0x79,
   0x59, 0xd6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x46, 0x7e, 0x48, 0x58, 0x4d, 0xd0,
   0x49, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x56, 0x90, 0x5f, 0xa9, 0x58, 0x58,
   0x5e, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x55, 0x55, 0x55, 0x55, 0x10, 0x10,
   0x10, 0x10, 0x18, 0x18, 0x18, 0x18, 0xff, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
]

##################################################
# QSFP56 200GBASE-AR4
##################################################
QsfpCmis200gAr4LowerPage00 = [
   0x1e, 0x40, 0x04, 0x02, 0x0f, 0x00, 0x00, 0x00,
   0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0xec,
   0x81, 0xbf, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32,
   0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0f, 0x03,
   0x44, 0x01, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
]

QsfpCmis200gAr4UpperPage01 = [
   0x32, 0x01, 0x41, 0x32, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x42, 0x68, 0x07, 0xd0, 0x24, 0xf0,
   0x55, 0x00, 0x46, 0x00, 0x00, 0x00, 0x9d, 0x19,
   0x00, 0xf0, 0x44, 0x33, 0x03, 0x06, 0x06, 0x03,
   0x07, 0x09, 0x3d, 0x00, 0x00, 0x00, 0x00, 0x25,
   0x55, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9a,
]

##################################################
# QSFP-CMIS 200GBASE-Cr4
# Sufficient to change identifier to QSFP-CMIS
##################################################

QsfpCmis200gCr4LowerPage00 = [
   0x1E, 0x27, 0x80, 0x01, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x1D, 0x01,
   0x88, 0x01, 0x1C, 0x01, 0x44, 0x11, 0x1B, 0x01,
   0x22, 0x55, 0x18, 0x01, 0x11, 0xFF, 0x1A, 0x01,
   0x44, 0x11, 0x16, 0x01, 0x11, 0xFF, 0x17, 0x01,
   0x44, 0x11, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
]

QsfpCmis200gCr4UpperPage00 = [
   0x1E, 'vn', 'vn', 'vn', 'vn', 'vn', 'vn', 'vn',
   'vn', 'vn', 'vn', 'vn', 'vn', 'vn', 'vn', 'vn',
   'vn', 0x78, 0xa7, 0x14, 0x4e, 0x44, 0x59, 0x59,
   0x59, 0x46, 0x2d, 0x30, 0x30, 0x30, 0x31, 0x20,
   0x20, 0x20, 0x20, 0x20, 0x30, 0x31, 'sn', 'sn',
   'sn', 'sn', 'sn', 'sn', 'sn', 'sn', 'sn', 'sn',
   'sn', 'sn', 'sn', 'sn', 'sn', 'sn', 'dc', 'dc',
   'dc', 'dc', 'dc', 'dc', 'dc', 'dc', 0x20, 0x20,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x01, 0x0a, 0x23, 0x05, 0x06,
   0x0b, 0x00, 0x00, 0x00, 0x00, 0x02, 0x0a, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
]

##################################################
# QSFP112 400GBASE-CR4
##################################################
QsfpCmis400gCr4LowerPage00 = [
   0x1e, 0x40, 0x80, 0x03, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x48, 0x01,
   0x44, 0x01, 0x1C, 0x01, 0x44, 0x01, 0x47, 0x01,
   0x22, 0x05, 0x18, 0x01, 0x11, 0x0F, 0x1A, 0x01,
   0x44, 0x01, 0x15, 0x01, 0x11, 0x0F, 0x17, 0x01,
   0x44, 0x11, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
]

##################################################
# QSFP112 400GBASE-CRA4
##################################################

QsfpCmis400gCra4LowerPage00 = [
   0x1e, 0x50, 0x00, 0x02, 0x01, 0x00, 0x00, 0x00,
   0x01, 0x0f, 0x00, 0x0a, 0x00, 0x00, 0x1c, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46, 0xc2,
   0xa0, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0xc2, 0x98, 0x4b, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x50, 0x04,
   0x44, 0x01, 0x4e, 0x04, 0x22, 0x05, 0x4c, 0x04,
   0x11, 0x0f, 0x0f, 0x04, 0x44, 0x01, 0x0d, 0x04,
   0x22, 0x05, 0x0a, 0x04, 0x11, 0x0f, 0x41, 0x04,
   0x44, 0x01, 0x08, 0x04, 0x22, 0x05, 0x00, 0x00,
   0x00, 0x00, 0x53, 0x48, 0x55, 0x54, 0x00, 0x00
]

QsfpCmis400gCra4UpperPage00 = [
   0x1e, 'vn', 'vn', 'vn', 'vn', 'vn', 'vn', 'vn',
   'vn', 'vn', 'vn', 'vn', 'vn', 'vn', 'vn', 'vn',
   'vn', 0x00, 0x09, 0x3a, 0x32, 0x32, 0x30, 0x32,
   0x39, 0x33, 0x30, 0x36, 0x30, 0x31, 0x20, 0x20,
   0x20, 0x20, 0x20, 0x20, 0x30, 0x31, 'sn', 'sn',
   'sn', 'sn', 'sn', 'sn', 'sn', 'sn', 'sn', 'sn',
   'sn', 'sn', 'sn', 'sn', 'sn', 'sn', 'dc', 'dc',
   'dc', 'dc', 'dc', 'dc', 'dc', 'dc', 0x20, 0x20,
   0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
   0x40, 0x1c, 0x42, 0x23, 0x00, 0x00, 0x00, 0x00,
   0x00, 0xc3, 0xb0, 0x02, 0x0c, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x65, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x41, 0x45, 0x43,
   0x46, 0x57, 0x31, 0x30, 0x30, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
]

QsfpCmis400gCra4UpperPage01 = [
   0x98, 0x4b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x84, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0xff, 0xff, 0x05, 0x05, 0x00, 0x00, 0x11,
   0x00, 0x00, 0x1c, 0x45, 0x01, 0x80, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x01, 0x05, 0x0f, 0x01, 0x05, 0x0f, 0x01, 0x05,
   0x0f, 0x01, 0x05, 0x0f, 0x01, 0x05, 0x0f, 0x01,
   0x00, 0x00, 0x98, 0x4b, 0x00, 0x20, 0x01, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
   0x04, 0x11, 0x0f, 0x48, 0x04, 0x44, 0x01, 0x47,
   0x04, 0x22, 0x05, 0x46, 0x04, 0x11, 0x0f, 0x1c,
   0x04, 0x44, 0x01, 0x1b, 0x04, 0x22, 0x05, 0x18,
   0x04, 0x11, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x6a
]

##################################################
# Finisar QSFP 100G AOC
##################################################

FinisarQsfpCmis100gLowerPage00 = [
   0x1e, 0x52, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0xd3,
   0x7d, 0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x42, 0x02,
   0x44, 0x01, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02,
]

FinisarQsfpCmis100gUpperPage00 = [
   0x1e, 0x46, 0x49, 0x4e, 0x49, 0x53, 0x41, 0x52,
   0x20, 0x43, 0x4f, 0x52, 0x50, 0x20, 0x20, 0x20,
   0x20, 0x00, 0x90, 0x65, 0x46, 0x43, 0x42, 0x52,
   0x39, 0x32, 0x35, 0x51, 0x45, 0x31, 0x43, 0x30,
   0x33, 0x43, 0x20, 0x20, 0x30, 0x31, 0x59, 0x56,
   0x34, 0x44, 0x36, 0x41, 0x52, 0x20, 0x20, 0x20,
   0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x32, 0x32,
   0x30, 0x39, 0x33, 0x30, 0x20, 0x20, 0x20, 0x20,
   0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
   0x40, 0x10, 0x43, 0x23, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7a, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
]

FinisarQsfpCmis100gUpperPage01 = [
   0x30, 0x31, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x42, 0x68, 0x07, 0xd0, 0x04, 0x00,
   0x66, 0x00, 0x46, 0x00, 0x00, 0x00, 0x9d, 0x18,
   0x50, 0x7a, 0x70, 0x2a, 0x03, 0x07, 0x06, 0x03,
   0x07, 0x07, 0x37, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd4,
]

FinisarQsfpCmis100gUpperPage02 = [
   0x4b, 0x00, 0xfb, 0x00, 0x49, 0x00, 0xfd, 0x00,
   0x8d, 0xcc, 0x74, 0x04, 0x87, 0x5a, 0x7a, 0x76,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x55, 0x76, 0x03, 0x90, 0x43, 0xe2, 0x06, 0xca,
   0x1d, 0x4c, 0x01, 0xf4, 0x17, 0x70, 0x03, 0xe8,
   0x55, 0x76, 0x02, 0x4d, 0x43, 0xe2, 0x03, 0xa5,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38,
]

FinisarQsfpCmis100gUpperPage10 = [
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
   0x11, 0x00, 0x00, 0x00, 0x66, 0x66, 0x66, 0x66,
   0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44,
   0x44, 0x44, 0x33, 0x33, 0x33, 0x33, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
]

FinisarQsfpCmis100gUpperPage11 = [
   0x44, 0x44, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x27, 0x25, 0x27, 0x33, 0x27, 0x4a,
   0x27, 0x38, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01,
   0x00, 0x01, 0x0c, 0xb2, 0x0c, 0xb2, 0x0c, 0xb2,
   0x0c, 0xb2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x27, 0x6b, 0x26, 0x0a, 0x25, 0x6f,
   0x23, 0x65, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01,
   0x00, 0x01, 0x11, 0x11, 0x00, 0x00, 0x11, 0x11,
   0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x00, 0x00,
   0x00, 0x66, 0x66, 0x66, 0x66, 0xff, 0xff, 0x00,
   0x00, 0x00, 0x00, 0x44, 0x44, 0x44, 0x44, 0x33,
   0x33, 0x33, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
]

##################################################
# Arista QSFP 400G-AR4 AOC
##################################################

# Lower Page 00h
QsfpCmis400gAr4LowerPage00 = QsfpCmis200gCr4LowerPage00[ : ]
QsfpCmis400gAr4LowerPage00[ 85 ] = 0x04 # Active Cables
QsfpCmis400gAr4LowerPage00[ 86 : 90 ] = [ 0x50, 0x03, 0x44, 0x01 ]  # Apsel1
QsfpCmis400gAr4LowerPage00[ 90 : 94 ] = [ 0x4e, 0x03, 0x22, 0x05 ]  # Apsel2
QsfpCmis400gAr4LowerPage00[ 94 : 99 ] = [ 0x4c, 0x03, 0x11, 0x0F, 0xff ]  # Apsel 3

QsfpCmis400gAr4UpperPage00 = QsfpCmis400gCra4UpperPage00[ : ]
# Vendor OUI
QsfpCmis400gAr4UpperPage00[ 17 : 20 ] = [ 0x00, 0x1c, 0x73 ]
# Vendor PN
QsfpCmis400gAr4UpperPage00[ 20 : 36 ] = "A-D400-Q400-5M  ".encode( "ascii" )
# Revision 40
QsfpCmis400gAr4UpperPage00[ 36 : 38 ] = [ 0x34, 0x30 ]
# Cable Assembly Length: Length multiplier field/base Length field
QsfpCmis400gAr4UpperPage00[ 74 : 76 ] = [ 0x45, 0x23 ]
# Checksum
QsfpCmis400gAr4UpperPage00[ 94 ] = 0x1e

# Upper Page 01h
QsfpCmis400gAr4UpperPage01 = QsfpCmis400gCra4UpperPage01[ : ]
# Media Lane asAssignment options
QsfpCmis400gAr4UpperPage01[ 48 : 52 ] = [ 0x01, 0x05, 0x0F, 0x00 ]
# Media Interface Technology
QsfpCmis400gAr4UpperPage00[ 84 ] = 0x00
# Checksum
QsfpCmis400gAr4UpperPage01[ 127 ] = 0xeb
