# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

##################################################
# QSFP-DD
# Id EEPROM taken from Amphenol 1m 30AWG module
##################################################

QsfpDd400gCr8LowerPage00 = [
   0x18, 0x27, 0x80, 0x01, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x1D, 0x01,
   0x88, 0x01, 0x1C, 0x01, 0x44, 0x11, 0x1B, 0x01,
   0x22, 0x55, 0x18, 0x01, 0x11, 0xFF, 0x1A, 0x01,
   0x44, 0x11, 0x16, 0x01, 0x11, 0xFF, 0x17, 0x01,
   0x44, 0x11, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
]

QsfpDd400gCr8UpperPage00 = [
   0x18, 'vn', 'vn', 'vn', 'vn', 'vn', 'vn', 'vn',
   'vn', 'vn', 'vn', 'vn', 'vn', 'vn', 'vn', 'vn',
   'vn', 0x78, 0xa7, 0x14, 0x4e, 0x44, 0x59, 0x59,
   0x59, 0x46, 0x2d, 0x30, 0x30, 0x30, 0x31, 0x20,
   0x20, 0x20, 0x20, 0x20, 0x30, 0x31, 'sn', 'sn',
   'sn', 'sn', 'sn', 'sn', 'sn', 'sn', 'sn', 'sn',
   'sn', 'sn', 'sn', 'sn', 'sn', 'sn', 'dc', 'dc',
   'dc', 'dc', 'dc', 'dc', 'dc', 'dc', 0x20, 0x20,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x01, 0x0a, 0x23, 0x05, 0x06,
   0x0b, 0x00, 0x00, 0x00, 0x00, 0x02, 0x0a, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
]

# BUG524695 radu: this page was taken as it is from a real ZR, but I changed byte
# 144 ( deinit/init max durations ) from 0x3a ( up to 5 min ) to 0x34 ( up to
# 100ms ). Our simulation code in XcvrCtrl is currently skipping
# simulateDataPathPwrCtrl if there are in-flight timers. This means that after we
# power up in a test, we will have problems writing again for 2.5 minutes ( it's
# currently set up to be half the max duration ).
# Updated checksum byte ( 255 ) from 0xd6 to 0xd0.
QsfpDd400gZrUpperPage01 = [
   0x00, 0x00, 0x00, 0x00, 0x8c, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x78, 0xea, 0x00, 0x03, 0x40, 0x0a,
   0x34, 0x82, 0x46, 0x14, 0x00, 0x00, 0x9d, 0x10,
   0x00, 0xf0, 0xff, 0xc3, 0x07, 0x07, 0x06, 0x1b,
   0x17, 0x09, 0x1d, 0x77, 0xff, 0x80, 0x00, 0x69,
   0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xba,
]

QsfpDd400gZrUpperPage04 = [
   0xa0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xe8,
   0x00, 0x23, 0x00, 0x00, 0x00, 0x00, 0xff, 0x9f,
   0x00, 0x8f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0xf7, 0x68,
   0xfa, 0xec, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
]

QsfpDd400gZrUpperPage12Bank0 = [ 0 ] * 128

# 400G-ZR VDM Pages
QsfpDd400gZrUpperPage2FBank0 = [ 0 ] * 128
# Set number of supported VDM groups to 4
QsfpDd400gZrUpperPage2FBank0[ 0 ] = 0x3

QsfpDd400gZrUpperPage20Bank0 = [
   0x00, 0x04, 0x00, 0x00, 0x20, 0x06, 0x21, 0x06,
   0x22, 0x06, 0x23, 0x06, 0x24, 0x06, 0x25, 0x06,
   0x26, 0x06, 0x27, 0x06, 0x50, 0x01, 0x40, 0x02,
   0x90, 0x03, 0x00, 0x00, 0x80, 0x07, 0x70, 0x08,
   0xa0, 0x0f, 0xa0, 0x09, 0xa0, 0x0b, 0xa0, 0x0d,
   0xc0, 0x17, 0xc0, 0x11, 0xc0, 0x13, 0xc0, 0x15,
   0xb0, 0x10, 0xb0, 0x0a, 0xb0, 0x0c, 0xb0, 0x0e,
   0xd0, 0x18, 0xd0, 0x12, 0xd0, 0x14, 0xd0, 0x16,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
]

QsfpDd400gZrUpperPage21Bank0 = [
   0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x00, 0x83,
   0x00, 0x84, 0x00, 0x85, 0x10, 0x86, 0x20, 0x87,
   0x30, 0x88, 0x40, 0x89, 0x50, 0x8a, 0x60, 0x8b,
   0x70, 0x8c, 0x80, 0x8d, 0x90, 0x8e, 0xa0, 0x8f,
   0xb0, 0x90, 0xc0, 0x91, 0xd0, 0x92, 0xe0, 0x93,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
]

# For better coverage, put VDM parameters
# in the groups 3 and 4
# Put VDM parameters 128,148-152 in group 3
QsfpDd400gZrUpperPage22Bank0 = [ 0 ] * 128
QsfpDd400gZrUpperPage22Bank0[ 0 : 12 ] = [ 0x00, 0x80, 0x00, 0x94,
                                           0x00, 0x95, 0x00, 0x96,
                                           0x00, 0x97, 0x00, 0x98 ]
# Put VDM parameters 80,128 in group 4
QsfpDd400gZrUpperPage23Bank0 = [ 0 ] * 128
QsfpDd400gZrUpperPage23Bank0[ 0 : 4 ] = [ 0x00, 0x81, 0x00, 0x50 ]

# 400G-ZR VDM Pages
QsfpDd400gZrUpperPage2FBank0 = [ 0 ] * 128
# Set number of supported VDM groups to 4
QsfpDd400gZrUpperPage2FBank0[ 0 ] = 0x3

QsfpDd400gZrUpperPage28Bank0 = [ 0 ] * 128
QsfpDd400gZrUpperPage28Bank0[ 24 : 32 ] = [ 0x64, 0x00, 0xe7, 0x00,
                                          0x5f, 0x00, 0xec, 0x00 ]

##################################################
#
# QSFPDd Id EEPROM definitions
#
# 800GBASE-ZR
#   - CMIS 5.2 compliant
#   - supports 1MHz TWI access
#   - custom media application 0xF1
#     ( 150GHz DWDM, Tx output Range A )
#
##################################################
QsfpDd800gZrLowerPage00 = [
   0x18, 0x52, 0x04, 0x03, 0x0f, 0x00, 0x00, 0x00, # 7
   0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xff, # 15
   0x7f, 0x7a, 0x00, 0x00, 0x7f, 0xff, 0x00, 0x00, # 23
   0x00, 0x00, 0x70, 0x00, 0x00, 0x00, 0x00, 0xc6, # 31
   0xff, 0xff, 0xff, 0x00, 0x00, 0x41, 0x01, 0x00, # 39
   0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, # 47
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, # 55
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, # 63
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, # 71
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, # 79
   0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x51, 0xf1, # 87
   0x81, 0x01, 0x4f, 0xf1, 0x41, 0x11, 0x4d, 0xf1, # 95
   0x21, 0x55, 0x4b, 0xf1, 0x11, 0xff, 0xff, 0xff, # 103
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, # 111
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, # 119
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  # 127
]

# media application code is SFF-8024 800ZR-A
Osfp800gZrLowerPage00 = QsfpDd800gZrLowerPage00[ : ]
Osfp800gZrLowerPage00[ 0 ] = 0x19
# media application code is SFF-8024 800ZR-B
Osfp800gZrBLowerPage00 = Osfp800gZrLowerPage00[ : ]
# media application code is SFF-8024 800ZR-C
Osfp800gZrCLowerPage00 = Osfp800gZrLowerPage00[ : ]

mediaCodeIdxs = ( 87, 91, 95, 99 )
for idx in mediaCodeIdxs:
   Osfp800gZrLowerPage00[ idx ] = 0x6C
   Osfp800gZrBLowerPage00[ idx ] = 0x6D
   Osfp800gZrCLowerPage00[ idx ] = 0x6E

QsfpDd800gZrUpperPage00 = [
   0x18, 'vn', 'vn', 'vn', 'vn', 'vn', 'vn', 'vn', # 135
   'vn', 'vn', 'vn', 'vn', 'vn', 'vn', 'vn', 'vn', # 143
   'vn', 0x00, 0x1c, 0x73, 0x51, 0x44, 0x44, 0x2d, # 151
   0x38, 0x30, 0x30, 0x47, 0x2d, 0x58, 0x44, 0x52, # 159
   0x20, 0x20, 0x20, 0x20, 0x41, 0x30, 0x41, 0x30, # 167
   0x33, 0x32, 0x30, 0x36, 0x30, 0x30, 0x30, 0x30, # 175
   0x36, 0x20, 0x20, 0x20, 0x20, 0x20, 0x32, 0x33, # 183
   0x30, 0x36, 0x30, 0x37, 0x57, 0x48, 0x41, 0x42, # 191
   0x43, 0x44, 0x45, 0x31, 0x32, 0x33, 0x34, 0x35, # 199
   0xe0, 0x78, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, # 207
   0x00, 0x00, 0xfe, 0x00, 0x10, 0x00, 0x00, 0x00, # 215
   0x00, 0x00, 0x00, 0x00, 0x00, 0xb0, 0x00, 0x00, # 223
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, # 231
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, # 239
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, # 247
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, # 255
]
Osfp800gZrUpperPage00 = QsfpDd800gZrUpperPage00[ : ]
Osfp800gZrUpperPage00[ 0 ] = 0x19

QsfpDd800gZrUpperPage01 = [
   0x00, 0x06, 0x00, 0x02, 0x8c, 0x00, 0x00, 0x00, # 135
   0x00, 0x00, 0x79, 0x4a, 0x00, 0x03, 0x64, 0x00, # 143
   0x79, 0x84, 0x4b, 0x00, 0x00, 0x00, 0x9d, 0x3f, # 151
   0x00, 0xf0, 0xff, 0xef, 0x07, 0x07, 0x06, 0x2b, # 159
   0x17, 0x09, 0x3d, 0x77, 0xff, 0x00, 0x00, 0x6a, # 167
   0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, # 175
   0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, # 183
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, # 191
   0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, # 199
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, # 207
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, # 215
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, # 223
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, # 231
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, # 239
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, # 247
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x71, # 255
]

##################################################
# QSFP-DD 400GBASE-Sr8 (CMIS 4.0)
# Replace the OSFP identifier with QSFP-DD
##################################################

QsfpDd400gSr8LowerPage00 = [
   0x18, 0x40, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0xf6,
   0x84, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x11, 0x10,
   0x88, 0x01, 0x0b, 0x09, 0x44, 0x11, 0x0a, 0x07,
   0x11, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
]

QsfpDd400gSr8UpperPage00 = [
   0x18, 'vn', 'vn', 'vn', 'vn', 'vn', 'vn', 'vn',
   'vn', 'vn', 'vn', 'vn', 'vn', 'vn', 'vn', 'vn',
   'vn', 0x44, 0x7c, 0x7f, 0x54, 0x2d, 0x4f, 0x53,
   0x38, 0x46, 0x4e, 0x53, 0x2d, 0x48, 0x30, 0x30,
   0x20, 0x20, 0x20, 0x20, 0x31, 0x41, 'sn', 'sn',
   'sn', 'sn', 'sn', 'sn', 'sn', 'sn', 'sn', 'sn',
   'sn', 'sn', 'sn', 'sn', 'sn', 'sn', 'dc', 'dc',
   'dc', 'dc', 'dc', 'dc', 'dc', 'dc', 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0xc0, 0x38, 0x00, 0x6a, 0x00, 0x46, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x50, 0x00, 0x00, 0x00, 0x37, 0x72,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
]

##################################################
# QSFP-DD 400GBASE-Sr8 (CMIS 3.0)
# Replace the 4.0 revision with 3.0 revision
##################################################

QsfpDd400gSr8Cmis3LowerPage00 = QsfpDd400gSr8LowerPage00[ : ]
QsfpDd400gSr8Cmis3LowerPage00[ 1 ] = 0x30

##################################################
# QSFP-DD 800GBASE-XDR8 (CMIS 5.0)
##################################################

QsfpDd800gXdr8LowerPage00 = [
   0x18, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, # 7
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, # 15
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, # 23
   0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, # 31
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, # 39
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, # 47
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, # 55
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, # 63
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, # 71
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, # 79
   0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x52, 0xd0, # 87
   0x88, 0x01, 0x50, 0x1c, 0x44, 0x11, 0x4e, 0x00, # 95
   0x22, 0x55, 0x4c, 0x15, 0x11, 0xff, 0xff, 0x00, # 103
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, # 111
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, # 119
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  # 127
]

QsfpDd800gXdr8UpperPage00 = [
   0x18, 'vn', 'vn', 'vn', 'vn', 'vn', 'vn', 'vn', # 135
   'vn', 'vn', 'vn', 'vn', 'vn', 'vn', 'vn', 'vn', # 143
   'vn', 0x00, 0x1c, 0x73, 0x51, 0x44, 0x44, 0x2d, # 151
   0x38, 0x30, 0x30, 0x47, 0x2d, 0x58, 0x44, 0x52, # 159
   0x38, 0x20, 0x20, 0x20, 0x35, 0x30, 'sn', 'sn', # 167
   'sn', 'sn', 'sn', 'sn', 'sn', 'sn', 'sn', 'sn', # 175
   'sn', 'sn', 'sn', 'sn', 'sn', 'sn', 'dc', 'dc', # 183
   'dc', 'dc', 'dc', 'dc', 'dc', 'dc', 0x20, 0x20, # 191
   0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, # 199
   0x00, 0x00, 0x00, 0x28, 0x00, 0x00, 0x00, 0x00, # 207
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, # 215
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, # 223
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, # 231
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, # 239
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, # 247
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, # 255
]

QsfpDd800gXdr8UpperPage01 = [
   0x00, 0x00, 0x00, 0x00, 0x42, 0x00, 0x00, 0x00, # 135
   0x00, 0x00, 0x66, 0x6c, 0x00, 0x00, 0x00, 0x00, # 143
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, # 151
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, # 159
   0x00, 0x00, 0x00, 0x77, 0xff, 0x1f, 0x80, 0x00, # 167
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, # 175
   0x01, 0x11, 0x55, 0xff, 0x00, 0x00, 0x00, 0x00, # 183
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, # 191
   0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, # 199
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, # 207
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, # 215
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, # 223
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, # 231
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, # 239
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, # 247
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x91, # 255
]

QsfpDd800gXdr8UpperPage02 = [
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, # 135
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, # 143
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, # 151
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, # 159
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, # 167
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, # 175
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, # 183
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, # 191
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, # 199
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, # 207
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, # 215
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, # 223
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, # 231
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, # 239
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, # 247
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, # 255
]

##################################################
# QSFP-DD 8x25GBASE-SR (CMIS 4.0)
##################################################
QsfpDd8x25gSrLowerPage00 = QsfpDd400gSr8LowerPage00[ : ]
QsfpDd8x25gSrUpperPage00 = QsfpDd400gSr8UpperPage00[ : ]

# Host / Media Interface ID Apps
QsfpDd8x25gSrLowerPage00[ 86 : 118 ] = [ 0x0B, 0x09, 0x44, 0x11, # Apsel1
                                         0x06, 0x04, 0x44, 0x11, # Apsel2
                                         0x05, 0x03, 0x11, 0xff, # Apsel3
                                         0x03, 0x02, 0x11, 0xff, # Apsel4
                                         0xff, 0x00, 0x00, 0x00,
                                         0x00, 0x00, 0x00, 0x00,
                                         0x00, 0x00, 0x00, 0x00,
                                         0x00, 0x00, 0x00, 0x00 ]

# QDD-8X25-MR-SR-E
QsfpDd8x25gSrUpperPage00[ 20 : 36 ] = [ 0x51, 0x44, 0x44, 0x2d,
                                        0x38, 0x58, 0x32, 0x35,
                                        0x2D, 0x4D, 0x52, 0x2d,
                                        0x53, 0x52, 0x2d, 0x45 ]
# Upper Page 01h
QsfpDd8x25gSrUpperPage01 = QsfpDd800gXdr8UpperPage01[ : ]

# Length Multiplier/Base Length (SMF)
QsfpDd8x25gSrUpperPage01[ 4 : 12 ] = [ 0x00, 0x32, 0x32, 0x23,
                                       0x00, 0x00, 0x42, 0x68 ]

# Media Lane Assignment Options
QsfpDd8x25gSrUpperPage01[ 48 : 52 ] = [ 0x11, 0x11, 0xff, 0xff ]

QsfpDd8x25gSrUpperPage01[ 67 ] = 0x00

# checksum
QsfpDd8x25gSrUpperPage01[ 127 ] = 0x66

##################################################
# QSFP-DD 800GBASE-2LR4 (CMIS 5.0)
##################################################
# Lower Page 00h
QsfpDd800g2lr4LowerPage00 = QsfpDd800gXdr8LowerPage00[ : ]
# Host / Media Interface ID Apps
QsfpDd800g2lr4LowerPage00[ 86 : 107 ] = [ 0x50, 0x1e, 0x44, 0x11, # Apsel1
                                          0x52, 0x00, 0x88, 0x01, # Apsel2
                                          0x4e, 0x00, 0x22, 0x55, # Apsel3
                                          0x4c, 0x16, 0x11, 0xff, # Apsel4
                                          0x0f, 0x19, 0x44, 0x11, # Apsel5
                                          0xff ]

# Upper Page 00h
QsfpDd800g2lr4UpperPage00 = QsfpDd800gXdr8UpperPage00[ : ]
# Vendor PN
QsfpDd800g2lr4UpperPage00[ 29 : 33 ] = [ 0x32, 0x4c, 0x52, 0x34 ]
# Connector Type
QsfpDd800g2lr4UpperPage00[ 75 ] = 0x25

# Upper Page 01h
QsfpDd800g2lr4UpperPage01 = QsfpDd800gXdr8UpperPage01[ : ]
# Length Multiplier / Base Length SMF
QsfpDd800g2lr4UpperPage01[ 4 ] = 0x4a
# Nominal Wavelength
QsfpDd800g2lr4UpperPage01[ 10 : 12 ] = [ 0x65, 0xa4 ]
# Media Lane Assignment Options for Apps 1 - 5
QsfpDd800g2lr4UpperPage01[ 48 : 53 ] = [ 0x11, 0x01, 0x55, 0xff, 0x11 ]
# Checksum
QsfpDd800g2lr4UpperPage01[ 127 ] = 0xe1

# Upper Page 02h
QsfpDd800g2lr4UpperPage02 = QsfpDd800gXdr8UpperPage02[ : ]

##################################################
# QSFP-DD 800GBASE-PLR8 (CMIS 5.0)
##################################################
# Lower Page 00h
QsfpDd800gPlr8LowerPage00 = QsfpDd800g2lr4LowerPage00[ : ]
# Host / Media Interface ID Apps
QsfpDd800gPlr8LowerPage00[ 86 : 103 ] = [ 0x52, 0x00, 0x88, 0x01, # Apsel1
                                          0x50, 0x00, 0x44, 0x11, # Apsel2
                                          0x4e, 0x00, 0x22, 0x55, # Apsel3
                                          0x4c, 0x16, 0x11, 0xff, # Apsel4
                                          0xff ]

# Upper Page 00h
QsfpDd800gPlr8UpperPage00 = QsfpDd800g2lr4UpperPage00[ : ]
# Vendor PN
QsfpDd800gPlr8UpperPage00[ 29 : 33 ] = [ 0x50, 0x4c, 0x52, 0x38 ]
# Connector Type
QsfpDd800gPlr8UpperPage00[ 75 ] = 0x28

# Upper Page 01h
QsfpDd800gPlr8UpperPage01 = QsfpDd800g2lr4UpperPage01[ : ]
# Nominal Wavelength
QsfpDd800gPlr8UpperPage01[ 10 : 12 ] = [ 0x66, 0x6c ]
# Media Lane Assignment Options for Apps 1 - 5
QsfpDd800gPlr8UpperPage01[ 48 : 53 ] = [ 0x01, 0x11, 0x55, 0xff, 0x00 ]
# Checksum
QsfpDd800gPlr8UpperPage01[ 127 ] = 0x99

# Upper Page 02h
QsfpDd800gPlr8UpperPage02 = QsfpDd800g2lr4UpperPage02[ : ]

##################################################
# QSFP-DD 800GBASE-SR8 (CMIS 5.0)
##################################################
QsfpDd800gSr8LowerPage00 = QsfpDd800gXdr8LowerPage00[ : ]
# Media Type
QsfpDd800gSr8LowerPage00[ 85 ] = 0x01
# Host/Media Apps
QsfpDd800gSr8LowerPage00[ 86 : 118 ] = [ 0x52, 0x12, 0x88, 0x01, # Apsel1
                                         0x50, 0x11, 0x44, 0x11, # Apsel2
                                         0x4e, 0x1b, 0x22, 0x55, # Apsel3
                                         0x4c, 0x0d, 0x11, 0xff, # Apsel4
                                         0x11, 0x10, 0x88, 0x01, # Apsel5
                                         0x0f, 0x0e, 0x44, 0x11, # Apsel6
                                         0x0d, 0x0c, 0x22, 0x55, # Apsel7
                                         0x0a, 0x07, 0x11, 0xff ] # Apsel8

QsfpDd800gSr8UpperPage00 = QsfpDd800gXdr8UpperPage00[ : ]
# Vendor PN
QsfpDd800gSr8UpperPage00[ 29 : 33 ] = [ 0x53, 0x52, 0x38, 0x20 ]
QsfpDd800gSr8UpperPage01 = QsfpDd800gXdr8UpperPage01[ : ]
# SMF
QsfpDd800gSr8UpperPage01[ 4 : 8 ] = [ 0x00, 0x32, 0x32, 0x23 ]
# Nominal Wavelength
QsfpDd800gSr8UpperPage01[ 10 : 12 ] = [ 0x42, 0x68 ]
# Media Lane Assignment for apps
QsfpDd800gSr8UpperPage01[ 52 : 56 ] = [ 0x01, 0x11, 0x55, 0xff ]
QsfpDd800gSr8UpperPage01[ 95 ] = 0xff
# Checksum
QsfpDd800gSr8UpperPage01[ 127 ] = 0x13
QsfpDd800gSr8UpperPage02 = QsfpDd800gXdr8UpperPage02

##################################################
# QSFP-DD 800GBASE-2SR4 (CMIS 5.0)
##################################################
QsfpDd800g2Sr4LowerPage00 = QsfpDd800gXdr8LowerPage00[ : ]
# Media type and Host/Media Apps
QsfpDd800g2Sr4LowerPage00[ 85 ] = 0x01
QsfpDd800g2Sr4LowerPage00[ 86 : 103 ] = [ 0x50, 0x11, 0x44, 0x11, # Apsel1
                                          0x52, 0x12, 0x88, 0x01, # Apsel2
                                          0x4e, 0x1b, 0x22, 0x55, # Apsel3
                                          0x4c, 0x0d, 0x11, 0xff, # Apsel4
                                          0xff ]

QsfpDd800g2Sr4UpperPage00 = QsfpDd800gXdr8LowerPage00[ : ]
# Vendor PN
QsfpDd800g2Sr4UpperPage00[ 29 : 33 ] = [ 0x32, 0x53, 0x52, 0x34 ]
# Connector Type
QsfpDd800g2Sr4UpperPage00[ 75 ] = 0x0c
# Media Interface Technology
QsfpDd800g2Sr4UpperPage00[ 84 ] = 0x00
QsfpDd800g2Sr4UpperPage01 = QsfpDd800gXdr8UpperPage01[ : 127 ]
# Base length SMF
QsfpDd800g2Sr4UpperPage01[ 4 : 8 ] = [ 0x00, 0x32, 0x32, 0x1e ]
# Nominal Wavelength
QsfpDd800g2Sr4UpperPage01[ 10 : 12 ] = [ 0x42, 0x68 ]
# Media Lane Assignment options for apps
QsfpDd800g2Sr4UpperPage01[ 48 : 49 ] = [ 0x11, 0x01 ]
# Checksum
QsfpDd800g2Sr4UpperPage01[ 127 ] = 0xba
QsfpDd800g2Sr4UpperPage02 = QsfpDd800gXdr8UpperPage02[ : ]

##################################################
# QSFP-DD 800GBASE-2XDR4 (CMIS 5.0)
##################################################
QsfpDd800g2Xdr4LowerPage00 = QsfpDd800g2lr4LowerPage00[ : ]
QsfpDd800g2Xdr4LowerPage00[ 86 : 103 ] = [ 0x50, 0x1c, 0x44, 0x11, # Apsel1
                                           0x52, 0x00, 0x88, 0x01, # Apsel2
                                           0x4e, 0x00, 0x22, 0x55, # Apsel3
                                           0x4c, 0x15, 0x11, 0xff, # Apsel4
                                           0xff ]
QsfpDd800g2Xdr4LowerPage00[ 103 : 107 ] = [ 0x00 ] * 4

QsfpDd800g2Xdr4UpperPage00 = QsfpDd800g2lr4UpperPage00[ : ]
QsfpDd800g2Xdr4UpperPage00[ 30 : 34 ] = [ 0x58, 0x44, 0x52, 0x34 ] # 'xdr4'
QsfpDd800g2Xdr4UpperPage00[ 75 ] = 0x0c # MPO 1x12 (Multifiber Parallel Optic)

QsfpDd800g2Xdr4UpperPage01 = QsfpDd800g2lr4UpperPage01[ : ]
QsfpDd800g2Xdr4UpperPage01[ 52 ] = 0x00 # No ApSel6
QsfpDd800g2Xdr4UpperPage01[ 127 ] = 0xd0

QsfpDd800g2Xdr4UpperPage02 = QsfpDd800g2lr4UpperPage02[ : ]

##################################################
# QSFP-DD 800GBASE-2DR4 (CMIS 5.0)
##################################################
QsfpDd800g2Dr4LowerPage00 = QsfpDd800g2Xdr4LowerPage00[ : ]
QsfpDd800g2Dr4LowerPage00[ 86 : 91 ] = [ 0x50, 0x1c, 0x44, 0x11, # Apsel1
                                           0xff ]
QsfpDd800g2Dr4LowerPage00[ 91 : 103 ] = [ 0x00 ] * 12

QsfpDd800g2Dr4UpperPage00 = QsfpDd800g2Xdr4UpperPage00[ : ]
QsfpDd800g2Dr4UpperPage00[ 30 : 34 ] = [ 0x44, 0x52, 0x34, 0x20 ] # 'dr4'

QsfpDd800g2Dr4UpperPage01 = QsfpDd800g2Xdr4UpperPage01[ : ]
# Set reach to 500m
QsfpDd800g2Dr4UpperPage01[ 4 ] = 5
QsfpDd800g2Dr4UpperPage01[ 127 ] = 0x8b # checksum

##################################################
# QSFP-DD LPO 800GBASE-2XDR4
##################################################
QsfpDdLpo800g2Xdr4UpperPage00 = QsfpDd800g2Xdr4UpperPage00[ : ]
QsfpDdLpo800g2Xdr4UpperPage00[ 20 : 36 ] = "LPD-800G-2XDR4  ".encode( "ascii" )

##################################################
# QSFP-DD 800GBASE-2PLR4 (CMIS 5.0)
##################################################
QsfpDd800g2Plr4LowerPage00 = QsfpDd800g2Xdr4LowerPage00[ : ]
QsfpDd800g2Plr4LowerPage00[ 86 : 103 ] = [ 0x50, 0x00, 0x44, 0x11, # Apsel1
                                           0x52, 0x00, 0x88, 0x01, # Apsel2
                                           0x4e, 0x00, 0x22, 0x55, # Apsel3
                                           0x4c, 0x16, 0x11, 0xff, # Apsel4
                                           0xff ]

QsfpDd800g2Plr4UpperPage00 = QsfpDd800g2Xdr4UpperPage00[ : ]
QsfpDd800g2Plr4UpperPage00[ 30 : 34 ] = [ 0x50, 0x4c, 0x52, 0x34 ] # 'plr4'

QsfpDd800g2Plr4UpperPage01 = QsfpDd800g2Xdr4UpperPage01[ : ]

QsfpDd800g2Plr4UpperPage02 = QsfpDd800g2Xdr4UpperPage02[ : ]

##################################################
# QSFP-DD 400GBASE-Sr8 Rev. 40
##################################################

QsfpDd400gSrbdLowerPage00 = QsfpDd400gSr8LowerPage00[ : ]
QsfpDd400gSrbdLowerPage00[ 26 ] = 0x40
QsfpDd400gSrbdLowerPage00[ 86 : 90 ] = [ 0x11, 0x1a, 0x88, 0x01 ]  # Apsel1
QsfpDd400gSrbdLowerPage00[ 90 : 94 ] = [ 0x0d, 0x0b, 0x22, 0x55 ]  # Apsel2
QsfpDd400gSrbdLowerPage00[ 94 : 99 ] = [ 0x0d, 0x00, 0x22, 0x55, 0xff ]  # Apsel 3

QsfpDd400gSrbdUpperPage00 = QsfpDd400gSr8UpperPage00[ : ]
QsfpDd400gSrbdUpperPage00[ 29 : 33 ] = [ 0x53, 0x52, 0x42, 0x44 ] # "SRBD"
QsfpDd400gSrbdUpperPage00[ 36 : 38 ] = [ 0x34, 0x30 ] # Revision 40
QsfpDd400gSrbdUpperPage00[ 75 ] = 0x0c # MPO 1x12 (Multifiber Parallel Optic)

QsfpDd400gSrbdUpperPage01 = [
   0x00, 0x00, 0x00, 0x00, 0x00, 0x4b, 0x32, 0x23,
   0x00, 0x00, 0x42, 0x68, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4b,
]

##################################################
# Finisar QSFP-DD 200G
##################################################
FinisarQsfpDd200gLowerPage00 = [
   0x18, 0x52, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1d, 0x5a,
   0x7d, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x42, 0x02,
   0x44, 0x11, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02,
]

FinisarQsfpDd200gUpperPage00 = [
   0x18, 0x46, 0x49, 0x4e, 0x49, 0x53, 0x41, 0x52,
   0x20, 0x43, 0x4f, 0x52, 0x50, 0x20, 0x20, 0x20,
   0x20, 0x00, 0x90, 0x65, 0x46, 0x43, 0x42, 0x52,
   0x39, 0x32, 0x35, 0x51, 0x45, 0x31, 0x43, 0x30,
   0x33, 0x43, 0x20, 0x20, 0x30, 0x31, 0x59, 0x56,
   0x34, 0x44, 0x36, 0x41, 0x52, 0x20, 0x20, 0x20,
   0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x32, 0x32,
   0x30, 0x39, 0x33, 0x30, 0x20, 0x20, 0x20, 0x20,
   0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
   0x40, 0x10, 0x43, 0x23, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
]

FinisarQsfpDd200gUpperPage01 = [
   0x30, 0x31, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x42, 0x68, 0x07, 0xd0, 0x04, 0x00,
   0x66, 0x00, 0x46, 0x00, 0x00, 0x00, 0x9d, 0x18,
   0x50, 0x7a, 0x70, 0x2a, 0x03, 0x07, 0x06, 0x03,
   0x07, 0x07, 0x37, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd4,
]

FinisarQsfpDd200gUpperPage02 = [
   0x4b, 0x00, 0xfb, 0x00, 0x49, 0x00, 0xfd, 0x00,
   0x8d, 0xcc, 0x74, 0x04, 0x87, 0x5a, 0x7a, 0x76,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x55, 0x76, 0x03, 0x90, 0x43, 0xe2, 0x06, 0xca,
   0x1d, 0x4c, 0x01, 0xf4, 0x17, 0x70, 0x03, 0xe8,
   0x55, 0x76, 0x02, 0x4d, 0x43, 0xe2, 0x03, 0xa5,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38,
]

FinisarQsfpDd200gUpperPage10 = [
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
   0x11, 0x00, 0x00, 0x00, 0x66, 0x66, 0x66, 0x66,
   0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44,
   0x44, 0x44, 0x33, 0x33, 0x33, 0x33, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
]

FinisarQsfpDd200gUpperPage11 = [
   0x44, 0x44, 0x44, 0x44, 0xff, 0xff, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x26, 0xe6, 0x26, 0xd5, 0x26, 0xeb,
   0x26, 0xda, 0x26, 0xe8, 0x26, 0xd7, 0x26, 0xed,
   0x26, 0xdc, 0x0c, 0xb2, 0x0c, 0xb2, 0x0c, 0xb2,
   0x0c, 0xb2, 0x0c, 0xb2, 0x0c, 0xb2, 0x0c, 0xb2,
   0x0c, 0xb2, 0x24, 0x28, 0x26, 0xb8, 0x26, 0x1e,
   0x25, 0x64, 0x27, 0x73, 0x2a, 0x04, 0x2a, 0x12,
   0x2a, 0x01, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
   0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x00, 0x00,
   0x00, 0x66, 0x66, 0x66, 0x66, 0xff, 0xff, 0x00,
   0x00, 0x00, 0x00, 0x44, 0x44, 0x44, 0x44, 0x33,
   0x33, 0x33, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
]

##################################################

# QSFP-DD 400GBASE-AR4 (CMIS 4.0)

##################################################

# Lower Page 00h
QsfpDd400gAr4LowerPage00 = QsfpDd800gXdr8LowerPage00[ : ]
QsfpDd400gAr4LowerPage00[ 85 ] = 0x04 # Active Cables
QsfpDd400gAr4LowerPage00[ 86 : 90 ] = [ 0x11, 0x03, 0x84, 0x01 ]  # Apsel1
QsfpDd400gAr4LowerPage00[ 90 : 94 ] = [ 0x0f, 0x03, 0x42, 0x11 ]  # Apsel2
QsfpDd400gAr4LowerPage00[ 94 : 99 ] = [ 0x0d, 0x03, 0x21, 0x55, 0xff ]  # Apsel 3

# Upper Page 00h
QsfpDd400gAr4UpperPage00 = QsfpDd800gXdr8UpperPage00[ : ]
# Vendor PN
QsfpDd400gAr4UpperPage00[ 20 : 36 ] = "A-D400-Q400-5M  ".encode( "ascii" )
# Revision 40
QsfpDd400gAr4UpperPage00[ 36 : 38 ] = [ 0x34, 0x30 ]
# Cable Assemply Length, Media Connector Type
QsfpDd400gAr4UpperPage00[ 74 : 76 ] = [ 0x45, 0x23 ]
# Checksum
QsfpDd400gAr4UpperPage00[ 94 ] = 0x1e

# Upper Page 01h
QsfpDd400gAr4UpperPage01 = QsfpDd800gXdr8UpperPage01[ : ]
# Length multplier
QsfpDd400gAr4UpperPage01[ 4 ] = 0x00
# Media Lane asAssignment options
QsfpDd400gAr4UpperPage01[ 48 : 52 ] = [ 0x01, 0x05, 0x0F, 0x00 ]
# Checksum
QsfpDd400gAr4UpperPage01[ 127 ] = 0xfe
