# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

#-------------------------------------------------------------------------------
# Register the CpuIntf class as able to participate in interface ranges.
#-------------------------------------------------------------------------------

import Intf.IntfRange as IntfRange # pylint: disable=consider-using-from-import
import IntfRangePlugin.EthIntf

class CpuPhyRangeIntfType( IntfRangePlugin.EthIntf.EthPhyRangeIntfTypeBase ):
   def __init__( self, helpdesc=None, **kwargs ):
      IntfRangePlugin.EthIntf.EthPhyRangeIntfTypeBase.__init__( self, name="Cpu",
         shortName="Cpu", desc="CPU interface",
         subSupported=False, subIntfGuard=None, **kwargs )

CpuAutoIntfType = CpuPhyRangeIntfType()
intfOptions = IntfRange.IntfOptions( ipSupport=True, routingProtoSupport=True )
IntfRange.registerIntfType( CpuAutoIntfType, intfOptions )

# this allows allIntfNames() to return CPU interfaces
IntfRangePlugin.EthIntf.registerConfiguredEthPhyIntfType( 'Cpu' )
