#!/usr/bin/env python3
# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliGlobal
import LazyMount
from Intf import IntfRange
from Toggles.SwagCoreToggleLib import toggleSwagPhase1Enabled

gv = CliGlobal.CliGlobal( ethLagIntfConfigDir=None )

class FabricChannelAutoIntf( IntfRange.AutoIntfType ):
   def __init__( self ):
      IntfRange.AutoIntfType.__init__( self, "Fabric-Channel", "Fc",
                                       "Fabric channel interface" )

   def collection( self ):
      if gv.ethLagIntfConfigDir is None:
         return []
      return filter( lambda x: x.startswith( 'Fabric-Channel' ),
                     gv.ethLagIntfConfigDir.intfConfig )

   def collectionVersion( self ):
      if gv.ethLagIntfConfigDir is None:
         return None

      versionList = [ gv.ethLagIntfConfigDir.intfConfig.version() ]
      return versionList

if toggleSwagPhase1Enabled():
   intfOptions = IntfRange.IntfOptions( ipSupport=False, routingProtoSupport=False )
   FabricChannelAutoIntfType = FabricChannelAutoIntf()
   IntfRange.registerIntfType( FabricChannelAutoIntfType, intfOptions )

def Plugin( entityManager ):
   gv.ethLagIntfConfigDir = LazyMount.mount(
      entityManager, "interface/config/eth/lag",
      "Interface::EthLagIntfConfigDir", "r" )
