# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

'''This module defines the fabric interface range plugin.'''

from __future__ import absolute_import, division, print_function

import CliGlobal
import CliParser
import Intf.IntfRange as IntfRange
import LazyMount
import Tracing

from BasicCliModes import GlobalConfigMode
from FabricIntfLib import Constants

t0 = Tracing.trace0

gv = CliGlobal.CliGlobal( dict( allFabricIntfStatusDir=None,
                                fabricCliCapabilities=None ) )

class FabricRangeIntfType( IntfRange.AutoIntfType ):
   def __init__( self ):
      super( FabricRangeIntfType, self ).__init__( "Fabric",
                                                   "Fa",
                                                   "Fabric Interfaces",
                                                   None,
                                                   wildcardSupported=True )

   def collection( self ):
      if gv.allFabricIntfStatusDir is None:
         return []

      return iter( gv.allFabricIntfStatusDir.intfStatus )

   def collectionVersion( self ):
      if gv.allFabricIntfStatusDir is None:
         return None

      versionList = [ gv.allFabricIntfStatusDir.intfStatus.version() ]
      t0( "FabricIntfRange version", versionList )

      return versionList

def fabricIntfConfigGuard( mode, token ):
   # Stop fabric interfaces from being matched on configuration commands
   # if the platform does not support them.
   if isinstance( mode, GlobalConfigMode ) and \
         not gv.fabricCliCapabilities.configIfModeSupported:
      return CliParser.guardNotThisPlatform
   return None

fabricAutoIntfType = FabricRangeIntfType()
intfOptions = IntfRange.IntfOptions( ipSupport=False, routingProtoSupport=False )
IntfRange.registerIntfType( fabricAutoIntfType, intfOptions )

IntfRange.registerIntfTypeGuard( fabricAutoIntfType, fabricIntfConfigGuard )

def Plugin( em ):
   #TODO BUG553312: This code path is ugly but needed since this plugin depends on
   #                the fact that the FabricIntfAgentPlugin has run. CLI Save code as
   #                well as CLI tests will sometimes load this plugin without
   #                starting the agent plugins which create this path.
   #                Since Fabric Interfaces don't yet support configuration and wont
   #                ever be enumerated in saved configuration this dirty hack is
   #                acceptable.
   if not em.localEntityExists( Constants.localAllFabricIntfStatusPath() ):
      t0(  'WARNING: The Fabric Interface Range plugin has started before the Fabric'
           'Interface Agent Plugin. Fabric Interface Enumeration Disabled.\n'
           'BUG553312' )
      return

   gv.allFabricIntfStatusDir = em.getLocalEntity(
      Constants.localAllFabricIntfStatusPath() )

   gv.fabricCliCapabilities = LazyMount.mount(
      em,
      Constants.fabricCapabilitiesCliPath(), 
      'Fabric::CliCapabilities',
      'r' )
