# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Intf.IntfRange as IntfRange # pylint: disable=consider-using-from-import
import itertools
import LazyMount

logicalPortStatusSliceDir = None

class LogicalPortPool( IntfRange.AutoIntfType ):
   def __init__( self ):
      super().__init__( 'pool', 'pool',
                        'Logical port pool',
                        [ 'Pool ID number' ] )

   def collection( self ):
      def _iterGroup( statusDir ):
         return itertools.chain.from_iterable(
            ( self.tagLong + k for k in d.poolStatus )
            for d in statusDir.values() )
      return itertools.chain.from_iterable(
         _iterGroup( d )
         for d in logicalPortStatusSliceDir.values() )

   def collectionVersion( self ):
      versionList = []
      for subSliceDir in sorted( logicalPortStatusSliceDir.values(),
                                 key=lambda d: d.name ):
         for logicalPortPoolStatusDir in sorted( subSliceDir.values(),
                                                 key=lambda d: d.name ):
            versionList.append( logicalPortPoolStatusDir.poolStatus.version() )
      return versionList

LogicalPortPoolType = LogicalPortPool()
# Register group type in order to use intfTypeFromName()
IntfRange.registerGroupType( LogicalPortPoolType )

def Plugin( em ):
   global logicalPortStatusSliceDir
   logicalPortStatusSliceDir = LazyMount.mount( em,
         "interface/archer/status/eth/phy/logicalport/slice", "Tac::Dir", "ri" )
