# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from Intf import IntfRange
import LazyMount

# -----------------------------------------------------------------------------------
# Create the PoeAutoIntfType to be used for interface range matching
# -----------------------------------------------------------------------------------

poeStatus = None

class PoeIntf( IntfRange.AutoIntfType ):
   def __init__( self ):
      IntfRange.AutoIntfType.__init__( self, "Ethernet", "Et",
                                       "PoE-enabled Ethernet interface",
                                       [ "Number of the port to use" ] )

   def collection( self ):
      return [ poeIntf.name for poeIntf in poeStatus.values() ]

PoeAutoIntfType = PoeIntf()

def Plugin( em ):
   global poeStatus
   poeStatus = LazyMount.mount( em,
         "environment/power/status/poePort", "Tac::Dir", "ri" )
