# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import itertools

import Intf.IntfRange as IntfRange # pylint: disable=consider-using-from-import
import LazyMount

speedGroupStatusSliceDir = None

class SpeedGroup( IntfRange.AutoIntfType ):
   def __init__( self ):
      super().__init__( 'speed-group', 'speed-group',
                        'Hardware speed group',
                        [ 'Group ID number' ] )

   def collection( self ):
      def _iterGroup( statusDir ):
         return itertools.chain( *( ( self.tagLong + k for k in d.group ) for d in
                                    statusDir.values() ) )
      return itertools.chain( *( _iterGroup( d ) for d in
                                 speedGroupStatusSliceDir.values() ) )

   def collectionVersion( self ):
      versionList = [ speedGroupStatusSliceDir.entityPtr.version() ]
      for subSliceDir in sorted( speedGroupStatusSliceDir.values(),
                                 key=lambda d: d.name ):
         for speedGroupStatusDir in sorted( subSliceDir.values(),
                                            key=lambda d: d.name ):
            versionList.append( speedGroupStatusDir.group.version() )
      return versionList

SpeedGroupType = SpeedGroup()
IntfRange.registerGroupType( SpeedGroupType )

def Plugin( em ):
   global speedGroupStatusSliceDir
   speedGroupStatusSliceDir = LazyMount.mount( em,
         "interface/archer/status/eth/phy/speedgroup/slice",
         "Tac::Dir", "ri" )
