# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

#-------------------------------------------------------------------------------
# Register the SwitchIntf class as able to participate in interface ranges.
#-------------------------------------------------------------------------------

import Intf.IntfRange as IntfRange # pylint: disable=consider-using-from-import
import IntfRangePlugin.EthIntf
import Tac

class SwitchPhyRangeIntfType( IntfRangePlugin.EthIntf.EthPhyRangeIntfTypeBase ):
   def __init__( self, helpdesc=None, **kwargs ):
      IntfRangePlugin.EthIntf.EthPhyRangeIntfTypeBase.__init__( self, name="Switch",
         shortName="Sw", desc="Switch interface",
         subSupported=True, subIntfGuard=IntfRange.subintfSupportedGuard,
         **kwargs )

SubIntfRangeDetails = Tac.Type( "Interface::SubIntfIdConstants" )
SubExtendedMin = SubIntfRangeDetails.subIntfExtendedIdMin
SubExtendedMax = SubIntfRangeDetails.subIntfExtendedIdMax
SwitchAutoIntfType = SwitchPhyRangeIntfType( intfSubLowerBound=SubExtendedMin,
      intfSubUpperBound=SubExtendedMax )
intfOptions = IntfRange.IntfOptions( ipSupport=True, routingProtoSupport=True )
IntfRange.registerIntfType( SwitchAutoIntfType, intfOptions )

# this allows allIntfNames() to return switch interfaces
IntfRangePlugin.EthIntf.registerConfiguredEthPhyIntfType( 'Switch' )
