#!/usr/bin/env python3
# Copyright (c) 2013 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Intf.IntfRange as IntfRange # pylint: disable=consider-using-from-import
import LazyMount

hwCapabilities = None

TunnelAutoIntfType = IntfRange.GenericRangeIntfType(
   lambda: ( 0, hwCapabilities.maxTunnelIntfNum - 1 ),
   "Tunnel", "tun", "Tunnel interface", lazyRange=True )

intfOptions = IntfRange.IntfOptions( ipSupport=True, routingProtoSupport=True )
IntfRange.registerIntfType( TunnelAutoIntfType, intfOptions )

def Plugin( entityManager ):
   global hwCapabilities
   hwCapabilities = LazyMount.mount(
         entityManager, 'routing/hardware/status',
         'Routing::Hardware::Status', 'r' )
