#!/usr/bin/env python3
# Copyright (c) 2013 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function
import Intf.IntfRange as IntfRange
import LazyMount

hwCapabilities = None

#-------------------------------------------------------------------------------
# Register the VxlanIntf class as able to participate in interface ranges.
#-------------------------------------------------------------------------------
def vxlanRangeFn( mode, context=None ):
   # Allow up to 8 VTIs while loading startup-config as hwCapabilities
   # is not yet available.
   if mode and mode.session_.startupConfig() and not mode.session_.guardsEnabled():
      return ( 1, 8 )
   return ( 1, hwCapabilities.vxlanMaxTunnelInterfacesSupported )

VxlanAutoIntfType = IntfRange.GenericRangeIntfType(
   vxlanRangeFn,
   "Vxlan", "Vx", "Vxlan Tunnel Interface",
   dynamicRange=True, lazyRange=True )
intfOptions = IntfRange.IntfOptions( ipSupport=False, routingProtoSupport=False )
IntfRange.registerIntfType( VxlanAutoIntfType, intfOptions )

def Plugin( entityManager ):
   global hwCapabilities
   hwCapabilities = LazyMount.mount(
         entityManager, 'bridging/hwcapabilities',
         'Bridging::HwCapabilities', 'r' )
