# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Logging

L1PROFILE_MODULE_APPLIED_FMT = 'L1 module profile configuration %s applied for %s'
L1PROFILE_MODULE_ERROR_FMT = 'L1 module profile configuration error for %s: %s'

PROFILE_DNE = 'the profile %s does not exist'
MODULE_INCOMPAT = 'profile %s incompatible with module'

L1PROFILE_MODULE_APPLIED = Logging.LogHandle( 'L1PROFILE_MODULE_APPLIED',
   severity=Logging.logInfo,
   fmt=L1PROFILE_MODULE_APPLIED_FMT,
   explanation='L1 Profile configuration has been successfully applied',
   recommendedAction=Logging.NO_ACTION_REQUIRED )

L1PROFILE_MODULE_ERROR = Logging.LogHandle( 'L1PROFILE_MODULE_ERROR',
   severity=Logging.logError,
   fmt=L1PROFILE_MODULE_ERROR_FMT,
   explanation='Error encountered while applying L1 Profile configuration',
   recommendedAction='Ensure that this module supports L1 Profiles, then provide a '
                     'valid L1 Profile configuration for this module' )
