# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac

ChipCategory = Tac.Type( 'PhyEee::ChipCategory' )
CATEGORY_UNKNOWN = ChipCategory.chipCategoryUnknown
CATEGORY_SWITCH_CHIP = ChipCategory.chipCategorySwitchChip
CATEGORY_EXTERNAL_PHY = ChipCategory.chipCategoryExternalPhy
CATEGORY_CROSSPOINT = ChipCategory.chipCategoryCrosspoint
CATEGORY_CPU_NIC = ChipCategory.chipCategoryCpuNic

ChannelId = Tac.Type( 'PhyEee::ChannelId' )
CHANNEL_UNSUPPORTED = ChannelId.unsupportedChannelId
CHANNEL_ANY = ChannelId.anyChannelId

Polarity = Tac.Type( "Inventory::Polarity" )
POLARITY_DEFAULT = Polarity.polarityDefault
POLARITY_SWAP = Polarity.polaritySwap

PhyScope = Tac.Type( 'PhyEee::PhyScope' )
PHY_SCOPE_LINE = PhyScope.phyScopeLine
PHY_SCOPE_SYSTEM = PhyScope.phyScopeSystem
PHY_SCOPE_UNKNOWN = PhyScope.phyScopeUnknown

SerdesGroupId = Tac.Type( 'Hardware::L1Topology::SerdesGroupId' )
UNKNOWN_SERDES_GROUP_ID = SerdesGroupId()

ChannelId = Tac.Type( 'PhyEee::ChannelId' )
UNSUPPORTED_CHANNEL_ID = ChannelId.unsupportedChannelId
ANY_CHANNEL_ID = ChannelId.anyChannelId

IntfRootId = Tac.Type( "L1::IntfSlotTypes::IntfRootId" )
UNKNOWN_INTF_ROOT_ID = IntfRootId()

LogicalPortPoolId = Tac.Type( "L1::LogicalPortPoolId" )
UNKNOWN_LOGICAL_PORT_POOL_ID = LogicalPortPoolId()
