# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# We install the package in a different path, so we need to add a custom specline
# here so that the rpm tooling can find the new path specified in the BUILD.qb file.
# pkgdeps: specline %{python_sitelib}/L1Topology/ModuleLib/__init__.py
# pkgdeps: specline %{python3_sitelib}/L1Topology/ModuleLib/__init__.py

from ArPyUtils.Types import ArException
from L1Topology.ModuleLib.Base import registeredModules
import L1Topology.ModuleLib.Xcvrs

def getModule( moduleName ):
   moduleCls = registeredModules.get( moduleName )
   if not moduleCls:
      raise ArException( 'Invalid module name.',
                         moduleName=moduleName,
                         validNames=list( registeredModules.values() ) )
   return moduleCls
