# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from TypeFuture import TacLazyType

LagSpeedUnit = TacLazyType( "Interface::LagSpeedUnit" )

def speedUnitStrFromEnum( minSpeedUnit ): # pylint: disable-msg=R1710
   if minSpeedUnit == LagSpeedUnit.speedUnitMbps:
      return 'mbps'
   elif minSpeedUnit == LagSpeedUnit.speedUnitGbps:
      return 'gbps'
   assert False, 'Not supported port-channel speed unit'

def speedUnitEnumFromStr( speedUnitStr ):
   assert speedUnitStr in [ 'gbps', 'mbps' ]
   if speedUnitStr == 'gbps':
      return LagSpeedUnit.speedUnitGbps
   return LagSpeedUnit.speedUnitMbps
