#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):

   # -------------------------------------------------------------------------
   # The Aaa agent runs unconditionally on "AllSupervisors", whichever
   # cell(s) (c.f. AID158) that actually corresponds to. For example,
   # in a fixed-config box, this would be on the one-and-only
   # cell, while in a modular chassis, it would run on the cells
   # corresponding to both supervisors.
   #
   # "Running unconditionally" is achieved by specifying no Runnabilities
   #
   # This might actually belong into a product-specific Launcher plugin,
   # e.g., into a Launcher plugin provided by the Aros package.
   # -------------------------------------------------------------------------
   agentName = "Aaa"
   agentCfg = { "name" : agentName,
                "exe" : "/usr/bin/Aaa",
                "argv" : [],
                "heartbeatPeriod" : 30,
                "oomScoreAdj" : -30, #  see AID3426
                "rssLimitBytes" : 200000000 }

   role = context.allSupervisorsRoleName
   context.agentConfigIs( role, agentCfg )
