# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Add explicit dependency on Launcher
# pkgdeps: import LauncherContext

def genAgentConfig( context, platform, attribute ):
   platformEntity = context.lookup( f'hardware/ale/runningL3Platform/{platform}' )
   platformRunnability = { 'entity': platformEntity, 'qualAttr': attribute }
   platformAgentCfg = { 'name': f'AleL3Agent-{attribute}-{platform}',
                        'launchName': f'AleL3Agent-{attribute}',
                        'exe': f'/usr/bin/AleL3Agent-{attribute}',
                        'argv': [ f'--platform={platform}' ],
                        'heartbeatPeriod': 30,
                        'runnability': platformRunnability }
   return platformAgentCfg

def Plugin( context ):
   primaryPlatforms = [
         'SandL3Unicast',
         'AleSamp',
         'StrataL3',
         'StrataL3Unicast',
         'SandL3Ni'
      ]
   secondaryPlatforms = []
   role = { 'rpr': context.activeSupervisorRoleName,
            'sso': context.allSupervisorsRoleName }

   for platform in primaryPlatforms:
      platformAgentCfg = genAgentConfig( context, platform, 'primary' )
      context.agentConfigIs( role, platformAgentCfg )

   for platform in secondaryPlatforms:
      platformAgentCfg = genAgentConfig( context, platform, 'secondary' )
      context.agentConfigIs( role, platformAgentCfg )
