#!/usr/bin/env python3
# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

bridgingEtbaStatusPath = "bridging/etba/status"

def Plugin( context ):
   etbaStatus = context.lookup( bridgingEtbaStatusPath )
   agentName = 'ArfaAegis'
   agentCfg = {
      'name': agentName,
      'exe': '/usr/bin/ArfaAegis',
      'argv': [],
      'heartbeatPeriod': 60,
      "runnability": [ { "entity": etbaStatus, "qualAttr": "isArfaMode" } ],
   }
   role = context.activeSupervisorRoleName
   context.agentConfigIs( role, agentCfg )
