#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):
   config = context.lookup( 'security/arpInspection/config' )
   status = context.lookup( 'security/arpInspection/status' )

   agentName = "ArpInspection"
   # If an interface is errdisabled due to ARP inspection rate limit, this interface
   # will not recover if ARP inspection agent is killed (i.e., feature is disabled
   # on all VLANs). Hence, causeStatus.intfStatus is added to the runnability to
   # ensure that the ARP inspection agent will not be killed when there exist
   # errdisabled interfaces.
   agentCfg = { "name" : agentName,
                "exe" : "/usr/bin/ArpInspection",
                "argv" : [],
                "heartbeatPeriod" : 30,
                "runnability" : [ { 'entity' : config,
                                    'qualAttr' : 'arpInspEnabled' },
                                  { 'entity' : status,
                                    'qualAttr' : 'enabled' },
                                  { 'qualPath': 'interface/errdisable/cause/'
                                    'arp-inspection.intfStatus/%*' } ]
              }

   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
