# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext
import Plugins

# Because of its 'runnability' setting, this agent is added to
# conditionalStartAgentsToIgnoreLauncherMsg in ArosTestPlugin to prevent spurious
# ptest failures due to unrecognized logs triggered by config change/tampering
def Plugin( context ):
   configEnt = context.lookup( "asic/resource/manager" )

   roleName = { 'sso': context.allSupervisorsRoleName,
                'rpr': context.activeSupervisorRoleName }

   def configureAgent( name, exe ):
      agentName = name
      runnability = { "entity" : configEnt, "qualAttr" : "agentEnabled" }

      extendedRunnability = []
      Plugins.loadPlugins( 'AsicResourceMgrRunnabilityPlugin', extendedRunnability )
      if extendedRunnability:
         runnability = ( runnability, extendedRunnability )

      agentCfg = { "name": agentName,
                   "exe": exe,
                   "argv": [],
                   "heartbeatPeriod": 30,
                   "oomScoreAdj": -300, # see AID3426
                   "runnability": runnability,
      }
      context.agentConfigIs( roleName, agentCfg )

   configureAgent( "AsicResourceMgr", "/usr/bin/AsicResourceMgr" )
