#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import LauncherPlugin.HttpService
# pkgdeps: import LauncherContext

def Plugin( context ):
   capiConfig = context.lookup(
      LauncherPlugin.HttpService.configPath( "http-commands" ) )
   httpServerStatus = context.lookup( 'mgmt/httpserver/status' )
   agentCfg = { "name": "CapiApp",
                "exe": "/usr/bin/CapiApp",
                "argv": [ "--ini", "/etc/uwsgi/CapiApp.ini" ],
                "heartbeatPeriod": 90,
                'runnability': [ { 'entity'   : capiConfig,
                                   'qualAttr' : 'enabled' },
                                 { 'entity'   : httpServerStatus,
                                   'qualAttr' : 'defaultServiceEnabled' } ] }
   context.agentConfigIs( context.activeSupervisorRoleName, agentCfg )


