# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Import used to generate dependency on Launcher
# pkgdeps: import LauncherContext

def Plugin( context ):
   runnabilityConfig = { 'qualPath': 'te/cbf/nexthopgroup/config/active' }
   runnabilityStatus = { 'qualPath': 'te/cbf/nexthopgroup/status/active' }

   agentCfg = { "name": "CbfNhg",
                "exe": "/usr/bin/CbfNhg",
                "argv": [],
                "heartbeatPeriod": 30,
                # Run if either the runnability config or status is active, which
                # means that we still have either Smash input (nhgOverrideConfig)
                # entries, or output (fecOverrideConfig) entries still configured
                "runnability": [ runnabilityConfig, runnabilityStatus ] }

   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
