# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):
   ccfConfig = context.lookup( "ccf/config" )
   ccfStatus = context.lookup( "ccf/status" )
   agentCfg = {
           "name": "CcfAgent",
           "exe": "/usr/bin/CcfAgent",
           "argv": [],
           "heartbeatPeriod": 30,
           "runnability": [ { "entity": ccfConfig,
                              "qualAttr": "active" },
                            { "entity": ccfStatus,
                              "qualAttr": "active" } ]
   }
   role = context.allSupervisorsRoleName
   context.agentConfigIs( role, agentCfg )
