#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):
   config = context.lookup( "cfm/config" )
   status = context.lookup( "cfm/status" )
   aleConfig = context.lookup( "cfm/aleConfig" )
   aleStatus = context.lookup( "cfm/aleStatus" )
   hwSupportStatus = context.lookup( "cfm/hwSupportStatus" )

   # CfmAgent is started if:
   # - either of the following exists (runnabilityA):
   #    - config.mdConfig or
   #    - status.mdStatus or
   #    - aleConfig.mdConfig or
   #    - aleStatus.mdStatus
   # and
   # - either of the following is True (runnabilityB):
   #    - hwSupportStatus.defaultMipHwSupported or
   #    - hwSupportStatus.upMepHwSupported or
   #    - hwSupportStatus.downMepHwSupported or
   #    - hwSupportStatus.cfmSwSupported

   # runnabilityA is the logical OR of all the conditions in it
   runnabilityA = [
         { 'entity' : config, 'qualAttr' : 'mdConfig' },
         { 'entity' : status, 'qualAttr' : 'mdStatus' },
         { 'entity' : aleConfig, 'qualAttr' : 'mdConfig' },
         { 'entity' : aleStatus, 'qualAttr' : 'mdStatus' } ]

   # runnabilityB is the logical OR of all the conditions in it
   runnabilityB = [
         { 'entity' : hwSupportStatus, 'qualAttr' : 'defaultMipHwSupported' },
         { 'entity' : hwSupportStatus, 'qualAttr' : 'upMepHwSupported' },
         { 'entity' : hwSupportStatus, 'qualAttr' : 'downMepHwSupported' },
         { 'entity' : hwSupportStatus, 'qualAttr' : 'cfmSwSupported' },
   ]

   cfmLmEnabled = [
      { 'entity' : config, 'qualAttr' : 'cfmLmEnabled' }
   ]

   cfmSlmEnabled = [
      { 'entity' : config, 'qualAttr' : 'cfmSlmEnabled' }
   ]

   runnability = [ ( runnabilityA, runnabilityB ), cfmLmEnabled, cfmSlmEnabled ]
   roleName = context.activeSupervisorRoleName
   agentName = 'CfmAgent'
   exeName = '/usr/bin/CfmAgent'
   agentCfg = { "name" : agentName,
                "exe" : exeName,
                "argv" : [],
                "heartbeatPeriod" : 30,
                "runnability" : runnability }

   context.agentConfigIs( roleName, agentCfg )
