# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):
   configTagPlatformStatus = context.lookup( 'configTag/platformStatus' )
   agentRunnability = [ { 'entity': configTagPlatformStatus,
                          'qualAttr': 'configTagSupported' } ]
   agentCfg = {
         "name": "ConfigTag",
         "exe": "/usr/bin/ConfigTag",
         "argv": [],
         "heartbeatPeriod": 30,
         "runnability": agentRunnability,
   }
   role = context.allSupervisorsRoleName
   context.agentConfigIs( role, agentCfg )
