# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):
   agentName = 'ConnectivityMonitorV2'
   status2 = context.lookup( 'connectivityMonitor/status2' )
   # Runnability depends on any client being present.
   agentRunnability = [
      { 'qualPath': 'connectivityMonitor/client/%*' },
      { 'entity': status2,
        'qualAttr': 'running' },
   ]

   agentCfg = { 'name': agentName,
                'exe': '/usr/bin/ConnectivityMonitorV2',
                'argv': [],
                'heartbeatPeriod': 30,
                "startupGracePeriod": 900,
                'runnability': agentRunnability,
              }

   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
