#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):
   controllerCfg = context.lookup( 'mgmt/controller/config' )
   cpaStatus = context.lookup( 'mgmt/controller/cpa/status' )
   # ProxyAgent depends on cvx being enabled on the active supervisor.
   agentName = "ControllerProxyAgent"
   agentCfg = { "name": agentName,
         "exe": "/usr/bin/ControllerProxyAgent",
         "argv": [],
         "heartbeatPeriod": 120,
         'runnability' : [ { 'entity' : controllerCfg, 'qualAttr' : "enabled" },
                           { 'entity' : cpaStatus, 'qualAttr' : "enabled" },
                         ]
         }
   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
