#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac

# pkgdeps: import LauncherContext

def Plugin( context ):
   controllerdbConfig = context.lookup( "controller/config" )
   controllerdbStatus = context.lookup( "controller/status" )

   # Controllerdb runs when enabled from the CLI
   controllerdbCfg = {
         "name": "Controllerdb",
         "exe": "/usr/bin/Controllerdb",
         "argv": [ '--scheduled' ],
         "heartbeatPeriod": 120,
         "runnability" : [ { "entity" : controllerdbConfig,
                             "qualAttr" : "enabled" },
                           { "entity" : controllerdbStatus,
                             "qualAttr" : "enabled" } ] }

   constants = Tac.Type( "Controller::Constants" )
   clusterName = constants.clusterDefaultName

   clusterConfig = context.lookup(
      "controller/cluster/configDir.config/" + clusterName )
   clusterStatus = context.lookup(
      "controller/cluster/statusDir.status/" + clusterName )

   # ControllerOob runs when enabled from the CLI and ControllerdbStatus is enabled
   controllerOobCfg = {
         "name": "ControllerOob",
         "exe": "/usr/bin/ControllerOob",
         "argv": [ '--scheduled' ],
         "heartbeatPeriod": 30,
         "runnability": [ ( { "entity": clusterConfig,
                              "qualAttr": "enabled" },
                            { "entity": controllerdbStatus,
                              "qualAttr": "enabled" } ),
                            { "entity": clusterStatus,
                              "qualAttr": "enabled" } ] }

   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, controllerdbCfg )
   context.agentConfigIs( roleName, controllerOobCfg )
