#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):
   agentName = "CpuComplex"

   # CpuComplex agent is started if the switch either has temperature sensors defined
   # or has sufficient memory capacity as defined in the Hardware::CpuComplexConfig
   # model.
   runnability = [ { "qualPath":
                        "hardware/cell/%cellId/cpuComplex/config.tempSensor/%*" },
                   { "qualPath":
                        "hardware/cell/%cellId/kabini/config.tempSensor/%*" } ]

   agentCfg = { "name": agentName,
                "exe": "/usr/bin/CpuComplex",
                "argv": [],
                "heartbeatPeriod": 30,
                "runnability": runnability }

   roleName = context.allCellsRoleName
   context.agentConfigIs( roleName, agentCfg )
