#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):
   agentStatus = context.lookup( 'te/cspf/agentStatus' )
   # Cspf agent should run only when at least one of it's
   # client is present (or) bgp ORR config is present
   bgpOrrPath = "cell/%cellId/routing/bgp/orrPositionRoot.orrPositionsByVrf/%*"
   agentName = 'Cspf'
   agentCfg = {
      'name' : agentName,
      'exe' : '/usr/bin/Cspf',
      'argv' : [],
      'heartbeatPeriod' : 30,
      'runnability' : [ { 'qualPath' : 'te/cspf/client/%*' },
                        { 'qualPath' : bgpOrrPath },
                        { 'entity' : agentStatus, 'qualAttr' : 'agentEnabled' }
      ]
   }
   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
