#!/usr/bin/env python3
# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):
   agentName = 'DaemonStateBroker'
   agentCfg = { 'name': agentName,
                         'exe': '/usr/bin/DaemonStateBroker',
                         'argv': [],
                         'heartbeatPeriod': 30,
                         'runnability': [ ( { 'qualPath':
                                               'daemon/agent/accessTokens/%*' } ),
                                           ]
   }
   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
