#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):

   dcbxConfig = context.lookup( 'dcb/dcbx/config' )

   agentCfg = { "name": "Dcbx",
                "exe": "/usr/bin/Dcbx",
                "argv": [],
                "heartbeatPeriod": 30,
                "runnability": [ { "entity": dcbxConfig,
                                   "qualAttr": "portDcbxEnabled" } ] }

   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
