#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):
   config = context.lookup( 'ip/helper/dhcprelay/config' )
   status = context.lookup( 'ip/helper/dhcprelay/status' )
   snoopingConfigV4 = context.lookup( 'bridging/dhcpsnooping/config' )
   serverStatus = context.lookup( 'dhcpServer/vrf/status' )
   dot1xProfilingDhcpInput = context.lookup( 'dot1x/profilingDhcpInput' )

   agentName = 'DhcpRelay'
   agentCfg = { 'name' : agentName,
                'exe' : '/usr/bin/DhcpRelay',
                'argv' : [],
                'heartbeatPeriod' : 30,
                'runnability': [ { 'entity' : config,
                                   'qualAttr' : 'intfConfig' },
                                 { 'entity' : config,
                                   'qualAttr' : 'serverIpGlobal' },
                                 { 'entity' : config,
                                   'qualAttr' : 'serverIp6Global' },
                                 { 'entity' : config,
                                   'qualAttr' : 'serverHostnameGlobal' },
                                 { 'entity' : config,
                                   'qualAttr' : 'alwaysOn' },
                                 { 'entity' : snoopingConfigV4,
                                   'qualAttr' : 'bridging' },
                                 { 'entity' : status,
                                   'qualAttr' : 'runControl' },
                                 { 'entity' : serverStatus,
                                   'qualAttr' : 'dhcpSnoopingV4Runnable' },
                                 { 'entity' : serverStatus,
                                   'qualAttr' : 'dhcpSnoopingV6Runnable' },
                                 { 'entity' : dot1xProfilingDhcpInput,
                                    'qualAttr' : 'profilingEnabled' } ] }

   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
