#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):
   # either one of directflow/configDir/{clb,cli,p4rt} is present and enabled
   configClb = context.lookup( "directflow/configDir/clb" )
   configCli = context.lookup( "directflow/configDir/cli" )
   configP4Rt = context.lookup( "directflow/configDir/p4rt" )
   dfStatus = context.lookup( "directflow/status" )
   ofStatus = context.lookup( "openflow/status" )

   # For runnability
   # Everything in a list is ORed
   # Everything in a tuple is ANDed
   runnability = [
      (
         [
            # clb or Cli or p4Rt says Enable
            { "entity" : configClb,
              "qualAttr" : "enabled" },
            { "entity" : configCli,
              "qualAttr" : "enabled" },
            { "entity" : configP4Rt,
              "qualAttr" : "enabled" }
         ],
         # and OF is inactive
         { "entity" : ofStatus,
           "qualAttr" : "inactive" },
      ),
      # OR Df is active
      # If agent was active and then shut - Agent will set its state to inactive
      { "entity" : dfStatus,
        "qualAttr" : "active" }
   ]
   agentCfg = { "name": "DirectFlow",
                "exe": "/usr/bin/DirectFlow",
                "argv": [ "--scheduled" ],
                "heartbeatPeriod": 30,
                "runnability": runnability
   }

   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
