#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext
from Toggles.RadiusToggleLib import toggleDot1xRadiusProxyMergeV0Enabled

def Plugin( context ):
   config = context.lookup( "dot1x/config" )
   status = context.lookup( "dot1x/status" )
   hwCapabilities = context.lookup( "bridging/hwcapabilities" )
   radiusProxyConfig = context.lookup( "radiusproxy/config" )
   radiusProxyStatus = context.lookup( "dot1x/radiusproxy/status" )

   agentName = "Dot1x"
   dot1xRunnability = [ { "entity": config,
                          "qualAttr": "dot1xEnabled" },
                        { "entity": status,
                          "qualAttr": "dot1xEnabled" },
                        { "entity": status,
                          "qualAttr": "dot1xIntfStatus" },
                        { "entity": hwCapabilities,
                          "qualAttr": "macBasedVlanSupported" } ]
   if toggleDot1xRadiusProxyMergeV0Enabled():
      dot1xRunnability.append( { "entity": radiusProxyConfig,
                                 "qualAttr": "radiusProxyEnabled" } )
      dot1xRunnability.append( { "entity": radiusProxyStatus,
                                 "qualAttr": "radiusProxyEnabled" } )
   agentCfg = { "name": agentName,
                "exe": "/usr/bin/Dot1x",
                "argv": [],
                "heartbeatPeriod": 30,
                "runnability": dot1xRunnability }

   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )

   # ********* Dot1x Web Agent *************/*

   webAgentStatus = context.lookup( "dot1x/webAgentStatus" )

   # only depend captive portal configuration and status to start dot1x web agent
   # it is possible that Dot1xWeb agent may run before Dot1x agent starts
   webAgentRunnability = [ { "entity": config, "qualAttr": "captivePortal" },
                           { "entity": webAgentStatus, "qualAttr": "running" } ]
   dot1xWebAgentCfg = { "name": "Dot1xWeb",
                        "exe": "/usr/bin/Dot1xWeb",
                        "argv": [],
                        "heartbeatPeriod": 30,
                        "runnability": webAgentRunnability }
   context.agentConfigIs( roleName, dot1xWebAgentCfg )
