# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

# pkgdeps: import LauncherContext

import Tac

FtConfig = Tac.Type( 'FlowTracking::Config' )

def Plugin( context ):
   dropExportLauncherPath = 'flowtracking/activeAgent/DropExport'
   ftrCapabilities = context.lookup(
      'hardware/flowtracking/capabilities/mirrorOnDrop' )
   modConfig = context.lookup(
      FtConfig.mirrorOnDropFlowTrackingCliConfigPath() )

   runnability = [
         (
            {
               'entity': ftrCapabilities,
               'qualAttr': 'supported',
            },
            {
               'entity': modConfig,
               'qualAttr': 'enabled',
            },
         ),
         {
            'qualPath': dropExportLauncherPath,
         },
   ]

   agentConfig = {
      'name': 'DropExport',
      'launchName': 'DropExport',
      'exe': '/usr/bin/DropExport',
      'argv': [],
      'heartbeatPeriod': 30,
      'runnability': runnability,
   }

   role = context.activeSupervisorRoleName
   context.agentConfigIs( role, agentConfig )
