#!/usr/bin/env python3
# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):
   agentName = 'EosSdkRpcControl'
   controlConfig = context.lookup( 'eossdkrpc/control/config' )
   # Control agent will be started once the user invokes
   # 'transport grpc <transport name>' under
   # the `management api eos-sdk-rpc mode` in the CLI
   agentCfg = { 'name': agentName,
                'exe': '/usr/bin/EosSdkRpcControl',
                'argv': [],
                'heartbeatPeriod': 30,
                'runnability': [ { 'entity': controlConfig,
                                   'qualAttr': 'enabled' } ]
   }
   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
