#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext
import ArfaStateAgent

bridgingEtbaConfigPath = "bridging/etba/config"
bridgingEtbaStatusPath = "bridging/etba/status"

def Plugin( context ):
   etbaConfig = context.lookup( bridgingEtbaConfigPath )
   etbaStatus = context.lookup( bridgingEtbaStatusPath )

   # Etba is launched by Launcher inside vEOS-lab and cEOS-lab.
   # We also need a launcher configuration in namespace duts,
   # since the trace cli only allows you to trace an agent that has a
   # launcher config.
   agentName = "Etba"
   agentCfg = { "name" : agentName,
                "exe" : "/usr/bin/Etba",
                "argv" : [ "--inNamespace" ],
                "oomScoreAdj" : -300, # see AID3426
                "heartbeatPeriod" : 30,
                "startupGracePeriod" : 300,
                "runnability": [ { "entity": etbaConfig,
                                 "qualAttr": 'extTapDevice' } ],
              }

   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )

   stateAgentName = ArfaStateAgent.name()
   stateAgentCfg = { "name" : stateAgentName,
                     "exe" : "/usr/bin/ArfaState",
                     "argv" : [],
                     "oomScoreAdj" : -300,
                     "heartbeatPeriod" : 30,
                     "startupGracePeriod" : 300,
                     "runnability": [ { "entity": etbaStatus,
                                        "qualAttr": "isArfaMode" } ],
                    }
   context.agentConfigIs( roleName, stateAgentCfg )
