#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Import used to generate dependency on Launcher
# pkgdeps : import LauncherContext

def Plugin( context ):
   # The EvpnrtrEncap agent requires a LauncherPlugin so that it can be started in
   # vEOS-lab duts.
   # Make the qualPath runnability the same as for ArBgp.
   # Tuple of runnabilities means "AND", so we must have
   # both ArBgp *and* t0xInterfacesRequired
   roleName = context.activeSupervisorRoleName
   agentName = "EvpnrtrEncap"
   exeName = "/usr/bin/EvpnrtrEncap"
   routingHwStatus = context.lookup( "routing/hardware/status" )
   runnability = ( { "qualPath" :
                     "cell/%cellId/routing/defaultVrfProtocolLaunch/Bgp" },
                   { "entity" : routingHwStatus,
                     "qualAttr" : "t0xInterfacesRequired" } )
   agentCfg = { "name": agentName,
                "exe": exeName,
                "argv": [],
                "heartbeatPeriod" : 120,
                "runnability" : runnability }

   context.agentConfigIs( roleName, agentCfg )
