#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):
   agentName = "Firewall"

   firewallCliConfig = context.lookup( "firewall/config/cli" )
   firewallOpenConfig = context.lookup( "firewall/config/openConfig" )
   firewallHwConfig = context.lookup( "firewall/hw/config" )
   firewallHwCapability = context.lookup( "firewall/hw/capability" )

   # Is Firewall enabled in CLI OR in HW config?
   # OR is Vrf collection still populated ?
   cliOrHwConfigEnabled = [
         { "entity" : firewallCliConfig,
           "qualAttr" : "enabled" },
         { "entity" : firewallOpenConfig,
           "qualAttr" : "enabled" },
         { "entity" : firewallHwConfig,
           "qualAttr" : "active" },
         { "qualPath" : "firewall/hw/config.vrf/%*" }
   ]

   # Does the platform support segment security?
   platformSupport = { "entity" : firewallHwCapability,
                       "qualAttr" : "segSecSupported" }

   # Set runnability to True if the platform supports AND enabled in CLI/HW config
   runnability = ( platformSupport, cliOrHwConfigEnabled )

   agentCfg = { "name" : agentName,
                "exe" : "/usr/bin/Firewall",
                "argv" : [],
                "heartbeatPeriod" : 30,
                "runnability" : runnability }

   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
