#!/usr/bin/env python3
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherContext

def Plugin( context ):
   config = context.lookup( "fastserverfailover/config" )
   status = context.lookup( "fastserverfailover/status" )

   agentName = "FastServerFailover"
   agentCfg = { "name": agentName,
                "exe": "/usr/bin/FastServerFailover",
                "argv": [],
                "heartbeatPeriod": 30,
                "runnability" : [ { "entity" : config,
                                    "qualAttr" : "enabled" },
                                  { "entity" : status,
                                    "qualAttr" : "enabled" } ] }

   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )

